/*
 * Decompiled with CFR 0.152.
 */
package com.github.rvesse.airline.io.writers;

import com.github.rvesse.airline.io.writers.WriterControlTracker;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public abstract class AnsiWriter
extends FilterWriter {
    private final List<WriterControlTracker> controls = new ArrayList<WriterControlTracker>();

    public AnsiWriter(Writer writer) {
        super(writer);
    }

    public final void registerControl(WriterControlTracker control) {
        if (control == null) {
            return;
        }
        this.controls.add(control);
    }

    public final void registerControls(WriterControlTracker ... controls) {
        if (controls == null) {
            return;
        }
        WriterControlTracker[] writerControlTrackerArray = controls;
        int n = controls.length;
        int n2 = 0;
        while (n2 < n) {
            WriterControlTracker control = writerControlTrackerArray[n2];
            this.registerControl(control);
            ++n2;
        }
    }

    @Override
    public void write(int c) throws IOException {
        this.applyAll();
        super.write(c);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.applyAll();
        super.write(cbuf, off, len);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.applyAll();
        super.write(str, off, len);
    }

    protected final void applyAll() throws IOException {
        for (WriterControlTracker control : this.controls) {
            control.apply();
        }
    }

    @Override
    public void close() throws IOException {
        this.resetAll();
        super.close();
    }

    protected final void resetAll() throws IOException {
        for (WriterControlTracker control : this.controls) {
            control.reset();
        }
    }
}

