/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push;

import org.apache.kafka.common.Node;
import org.apache.kafka.common.message.AppendRecordsRequestData;

public abstract class PushSession {
    private final int leaderEpoch;
    private final long replicaEpoch;
    private final long replicationSessionId;
    private final Node replicaNode;

    public PushSession(int leaderEpoch, long replicaEpoch, long replicationSessionId, Node replicaNode) {
        this.leaderEpoch = leaderEpoch;
        this.replicaEpoch = replicaEpoch;
        this.replicationSessionId = replicationSessionId;
        this.replicaNode = replicaNode;
    }

    public abstract boolean onAppendRecordsResponse(long var1, long var3);

    public abstract void onPushSessionEnded();

    public abstract void tryCompleteDelayedRequests();

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public long replicaEpoch() {
        return this.replicaEpoch;
    }

    public long replicationSessionId() {
        return this.replicationSessionId;
    }

    public Node replicaNode() {
        return this.replicaNode;
    }

    public boolean matchesRequestData(long requestReplicaEpoch, AppendRecordsRequestData.PartitionData data) {
        return this.replicaEpoch == requestReplicaEpoch && this.leaderEpoch == data.currentLeaderEpoch() && this.replicationSessionId == data.replicationSessionId();
    }

    public String toString() {
        return "PushSession{leaderEpoch=" + this.leaderEpoch + ", replicaEpoch=" + this.replicaEpoch + ", replicationSessionId=" + this.replicationSessionId + ", replicaNode=" + String.valueOf(this.replicaNode) + "}";
    }
}

