/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.replication.push.buffer;

import io.confluent.kafka.replication.push.PushSession;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.AppendRecordsRequestData;
import org.apache.kafka.common.record.AbstractRecords;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MultiBufferRecords;
import org.apache.kafka.server.common.TopicIdPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BufferingPartitionDataBuilder {
    private static final Logger log = LoggerFactory.getLogger(BufferingPartitionDataBuilder.class);
    static final long UNSET_OFFSET_VALUE = -1L;
    private final TopicIdPartition topicIdPartition;
    private final PushSession initialSession;
    private final long maxSizeInBytes;
    private final List<AbstractRecords> records;
    boolean notifySessionEnded = false;
    private long appendOffset = -1L;
    private long highWatermark = -1L;
    private long logStartOffset = -1L;
    private long sizeInBytes = 0L;

    BufferingPartitionDataBuilder(TopicIdPartition topicIdPartition, PushSession initialSession, long maxSizeInBytes) {
        this.topicIdPartition = topicIdPartition;
        this.initialSession = initialSession;
        this.maxSizeInBytes = maxSizeInBytes;
        this.records = new ArrayList<AbstractRecords>();
    }

    public List<AbstractRecords> stopPushAndDiscardState(boolean sendEndSessionRequest) {
        this.notifySessionEnded = sendEndSessionRequest;
        return this.discardState();
    }

    List<AbstractRecords> discardState() {
        ArrayList<AbstractRecords> evictedRecords = new ArrayList<AbstractRecords>(this.records);
        this.records.clear();
        this.appendOffset = -1L;
        this.highWatermark = -1L;
        this.logStartOffset = -1L;
        return evictedRecords;
    }

    private boolean acceptPartitionUpdate(PushSession pushSession) {
        return this.isInitialPushSession(pushSession) && !this.notifySessionEnded;
    }

    public boolean addHighWatermarkUpdate(PushSession pushSession, long highWatermark) {
        if (this.acceptPartitionUpdate(pushSession)) {
            this.highWatermark = Math.max(this.highWatermark, highWatermark);
            return true;
        }
        return false;
    }

    public boolean addLogStartOffsetUpdate(PushSession pushSession, long logStartOffset) {
        if (this.acceptPartitionUpdate(pushSession)) {
            this.logStartOffset = Math.max(this.logStartOffset, logStartOffset);
            return true;
        }
        return false;
    }

    public boolean addMemoryRecords(PushSession pushSession, MemoryRecords memoryRecords, long appendOffset) {
        long newSizeInBytes = this.sizeInBytes + (long)memoryRecords.sizeInBytes();
        if (!this.acceptPartitionUpdate(pushSession)) {
            return false;
        }
        if (!this.records.isEmpty() && newSizeInBytes > this.maxSizeInBytes) {
            return false;
        }
        this.records.add((AbstractRecords)memoryRecords);
        this.sizeInBytes = newSizeInBytes;
        if (this.appendOffset == -1L) {
            this.appendOffset = appendOffset;
        }
        return true;
    }

    AppendRecordsRequestData.PartitionData build() {
        AppendRecordsRequestData.PartitionData partitionData = new AppendRecordsRequestData.PartitionData().setPartitionIndex(this.topicIdPartition.partitionId()).setCurrentLeaderEpoch(this.initialSession.leaderEpoch()).setReplicationSessionId(this.initialSession.replicationSessionId()).setRecords((BaseRecords)MemoryRecords.EMPTY);
        if (this.notifySessionEnded) {
            partitionData.setEndReplicationSession(true);
            return partitionData;
        }
        partitionData.setAppendOffset(this.appendOffset).setHighWatermark(this.highWatermark).setLogStartOffset(this.logStartOffset);
        if (!this.records.isEmpty()) {
            List<MemoryRecords> memoryRecords = this.records.stream().filter(r -> r instanceof MemoryRecords).map(r -> (MemoryRecords)r).collect(Collectors.toList());
            partitionData.setRecords((BaseRecords)new MultiMemoryRecords(memoryRecords));
        }
        return partitionData;
    }

    List<AbstractRecords> records() {
        return Collections.unmodifiableList(this.records);
    }

    long appendOffset() {
        return this.appendOffset;
    }

    long highWatermark() {
        return this.highWatermark;
    }

    long logStartOffset() {
        return this.logStartOffset;
    }

    private boolean isInitialPushSession(PushSession currentSession) {
        if (!this.initialSession.equals(currentSession)) {
            log.warn("Received event for invalid push session - expected {}, but got {}", (Object)this.initialSession, (Object)currentSession);
            return false;
        }
        return true;
    }

    public static final class MultiMemoryRecords
    extends MultiBufferRecords {
        private final List<MemoryRecords> memoryRecords;
        private final ByteBuffer[] buffers;
        private final int size;

        public MultiMemoryRecords(List<MemoryRecords> memoryRecords) {
            this.memoryRecords = memoryRecords;
            this.buffers = new ByteBuffer[memoryRecords.size()];
            int totalSize = 0;
            for (int i = 0; i < memoryRecords.size(); ++i) {
                MemoryRecords curr = memoryRecords.get(i);
                this.buffers[i] = curr.buffer();
                totalSize += curr.sizeInBytes();
            }
            this.size = totalSize;
        }

        public List<MemoryRecords> memoryRecords() {
            return Collections.unmodifiableList(this.memoryRecords);
        }

        public ByteBuffer[] buffers() {
            return this.buffers;
        }

        public int sizeInBytes() {
            return this.size;
        }

        public void release() {
        }
    }
}

