/*
 * Decompiled with CFR 0.152.
 */
package io.cloudevents.jackson;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.cloudevents.CloudEvent;
import io.cloudevents.CloudEventData;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.format.EventDeserializationException;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.format.EventSerializationException;
import io.cloudevents.jackson.CloudEventDeserializer;
import io.cloudevents.jackson.CloudEventSerializer;
import io.cloudevents.jackson.JsonFormatOptions;
import io.cloudevents.rw.CloudEventDataMapper;
import io.cloudevents.rw.CloudEventRWException;
import java.io.IOException;
import java.util.regex.Pattern;

public final class JsonFormat
implements EventFormat {
    public static final String CONTENT_TYPE = "application/cloudevents+json";
    private static final Pattern JSON_CONTENT_TYPE_PATTERN = Pattern.compile("^(application|text)\\/([a-zA-Z]+\\+)?json(;.*)*$");
    private final ObjectMapper mapper = new ObjectMapper();
    private final JsonFormatOptions options;

    public JsonFormat(boolean forceDataBase64Serialization, boolean forceStringSerialization) {
        this(JsonFormatOptions.builder().forceDataBase64Serialization(forceDataBase64Serialization).forceStringSerialization(forceStringSerialization).build());
    }

    public JsonFormat(JsonFormatOptions options) {
        this.mapper.registerModule((Module)JsonFormat.getCloudEventJacksonModule(options));
        this.options = options;
    }

    public JsonFormat() {
        this(new JsonFormatOptions());
    }

    public JsonFormat withForceJsonDataToBase64() {
        return new JsonFormat(JsonFormatOptions.builder().forceDataBase64Serialization(true).forceStringSerialization(this.options.isForceStringSerialization()).forceExtensionNameLowerCaseDeserialization(this.options.isForceExtensionNameLowerCaseDeserialization()).forceIgnoreInvalidExtensionNameDeserialization(this.options.isForceIgnoreInvalidExtensionNameDeserialization()).build());
    }

    public JsonFormat withForceNonJsonDataToString() {
        return new JsonFormat(JsonFormatOptions.builder().forceDataBase64Serialization(this.options.isForceDataBase64Serialization()).forceStringSerialization(true).forceExtensionNameLowerCaseDeserialization(this.options.isForceExtensionNameLowerCaseDeserialization()).forceIgnoreInvalidExtensionNameDeserialization(this.options.isForceIgnoreInvalidExtensionNameDeserialization()).build());
    }

    public JsonFormat withForceExtensionNameLowerCaseDeserialization() {
        return new JsonFormat(JsonFormatOptions.builder().forceDataBase64Serialization(this.options.isForceDataBase64Serialization()).forceStringSerialization(this.options.isForceStringSerialization()).forceExtensionNameLowerCaseDeserialization(true).forceIgnoreInvalidExtensionNameDeserialization(this.options.isForceIgnoreInvalidExtensionNameDeserialization()).build());
    }

    public JsonFormat withForceIgnoreInvalidExtensionNameDeserialization() {
        return new JsonFormat(JsonFormatOptions.builder().forceDataBase64Serialization(this.options.isForceDataBase64Serialization()).forceStringSerialization(this.options.isForceStringSerialization()).forceExtensionNameLowerCaseDeserialization(this.options.isForceExtensionNameLowerCaseDeserialization()).forceIgnoreInvalidExtensionNameDeserialization(true).build());
    }

    public byte[] serialize(CloudEvent event) throws EventSerializationException {
        try {
            return this.mapper.writeValueAsBytes((Object)event);
        }
        catch (JsonProcessingException e) {
            throw new EventSerializationException((Throwable)e);
        }
    }

    public CloudEvent deserialize(byte[] bytes) throws EventDeserializationException {
        try {
            return (CloudEvent)this.mapper.readValue(bytes, CloudEvent.class);
        }
        catch (IOException e) {
            throw new EventDeserializationException((Throwable)e);
        }
    }

    public CloudEvent deserialize(byte[] bytes, CloudEventDataMapper<? extends CloudEventData> mapper) throws EventDeserializationException {
        CloudEvent deserialized = this.deserialize(bytes);
        if (deserialized.getData() == null) {
            return deserialized;
        }
        try {
            return CloudEventBuilder.from((CloudEvent)deserialized).withData(mapper.map(deserialized.getData())).build();
        }
        catch (CloudEventRWException e) {
            throw new EventDeserializationException((Throwable)e);
        }
    }

    public String serializedContentType() {
        return CONTENT_TYPE;
    }

    public static SimpleModule getCloudEventJacksonModule() {
        return JsonFormat.getCloudEventJacksonModule(false, false);
    }

    public static SimpleModule getCloudEventJacksonModule(boolean forceDataBase64Serialization, boolean forceStringSerialization) {
        return JsonFormat.getCloudEventJacksonModule(JsonFormatOptions.builder().forceDataBase64Serialization(forceDataBase64Serialization).forceStringSerialization(forceStringSerialization).build());
    }

    public static SimpleModule getCloudEventJacksonModule(JsonFormatOptions options) {
        SimpleModule ceModule = new SimpleModule("CloudEvent");
        ceModule.addSerializer(CloudEvent.class, (JsonSerializer)new CloudEventSerializer(options.isForceDataBase64Serialization(), options.isForceStringSerialization()));
        ceModule.addDeserializer(CloudEvent.class, (JsonDeserializer)new CloudEventDeserializer(options.isForceExtensionNameLowerCaseDeserialization(), options.isForceIgnoreInvalidExtensionNameDeserialization(), options.isDataContentTypeDefaultingDisabled()));
        return ceModule;
    }

    static boolean dataIsJsonContentType(String contentType) {
        return contentType == null || JSON_CONTENT_TYPE_PATTERN.matcher(contentType).matches();
    }
}

