/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.codegen.helpers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.InListExpression;
import io.confluent.ksql.execution.expression.tree.InPredicate;
import io.confluent.ksql.execution.expression.tree.NullLiteral;
import io.confluent.ksql.execution.util.CoercionUtil;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.schema.ksql.SqlBooleans;
import io.confluent.ksql.schema.ksql.types.SqlType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;

public final class InListEvaluator {
    private static final Object NO_MATCH = new Object();
    private static final ImmutableMap<Class<?>, Function<String, ?>> STRING_PARSERS = ImmutableMap.of(Boolean.class, InListEvaluator::stringToBoolean, Integer.class, Integer::valueOf, Long.class, Long::valueOf, Double.class, Double::valueOf, BigDecimal.class, BigDecimal::new);
    private static final ImmutableMap<Class<? extends Number>, BiFunction<Number, Number, ? extends Number>> WIDENERS = ImmutableMap.builder().put(Integer.class, (v, t) -> v.intValue()).put(Long.class, (v, t) -> v.longValue()).put(Double.class, (v, t) -> v.doubleValue()).put(BigDecimal.class, InListEvaluator::numberToDecimalValue).build();
    private static final ImmutableList<Handler> MATCHERS = ImmutableList.builder().add(InListEvaluator::nullsNeverMatch).add((Object)InListEvaluator.handler(List.class, InListEvaluator::arraysMatch)).add((Object)InListEvaluator.handler(Map.class, InListEvaluator::mapsMatch)).add((Object)InListEvaluator.handler(Struct.class, InListEvaluator::structsMatch)).add(InListEvaluator::exactMatch).add((Object)InListEvaluator.handler(String.class, Object.class, InListEvaluator::parsedMatches)).add((Object)InListEvaluator.handler(Object.class, String.class, InListEvaluator::parsedMatches)).add((Object)InListEvaluator.handler(Number.class, Number.class, InListEvaluator::numbersMatch)).build();

    private InListEvaluator() {
    }

    public static InPredicate preprocess(InPredicate predicate, ExpressionTypeManager typeManager, Map<String, SqlType> lambdaTypeMapping) {
        ImmutableList nonNull = ImmutableList.builder().add((Object)predicate.getValue()).addAll((Iterable)predicate.getValueList().getValues().stream().filter(e -> !(e instanceof NullLiteral)).collect(Collectors.toList())).build();
        List<Expression> coerced = CoercionUtil.coerceUserList((Collection<Expression>)nonNull, typeManager, lambdaTypeMapping).expressions();
        return new InPredicate(predicate.getLocation(), coerced.get(0), new InListExpression(predicate.getValueList().getLocation(), coerced.subList(1, coerced.size())));
    }

    public static boolean matches(Object value, Object ... values) {
        if (value == null) {
            return false;
        }
        for (Object v : values) {
            if (v == null || !InListEvaluator.isMatch(value, v)) continue;
            return true;
        }
        return false;
    }

    private static boolean isMatch(Object requiredValue, Object possibleMatch) {
        for (Handler handler : MATCHERS) {
            Optional<Boolean> result = handler.accept(requiredValue, possibleMatch);
            if (!result.isPresent()) continue;
            return result.get();
        }
        return false;
    }

    private static boolean isStructuredMatch(Object requiredValue, Object possibleMatch) {
        if (requiredValue == null && possibleMatch == null) {
            return true;
        }
        return InListEvaluator.isMatch(requiredValue, possibleMatch);
    }

    private static Optional<Boolean> nullsNeverMatch(Object requiredValue, Object possibleMatch) {
        if (requiredValue == null || possibleMatch == null) {
            return Optional.of(false);
        }
        return Optional.empty();
    }

    private static Optional<Boolean> exactMatch(Object requiredValue, Object possibleMatch) {
        if (requiredValue.equals(possibleMatch)) {
            return Optional.of(true);
        }
        return Optional.empty();
    }

    private static Object parseString(String value, Class<?> requiredType) {
        Function parser = (Function)STRING_PARSERS.get(requiredType);
        if (parser == null) {
            return NO_MATCH;
        }
        try {
            return parser.apply(value);
        }
        catch (NumberFormatException e) {
            return NO_MATCH;
        }
    }

    private static boolean parsedMatches(String requiredValue, Object possibleMatch) {
        return InListEvaluator.parsedMatches(possibleMatch, requiredValue);
    }

    private static boolean parsedMatches(Object requiredValue, String possibleMatch) {
        Object parsed = InListEvaluator.parseString(possibleMatch, requiredValue.getClass());
        return requiredValue.equals(parsed);
    }

    private static boolean numbersMatch(Number requiredValue, Number possibleMatch) {
        Number possible = possibleMatch.getClass().equals(requiredValue.getClass()) ? (Number)possibleMatch : (Number)((Number)((BiFunction)WIDENERS.get(requiredValue.getClass())).apply(possibleMatch, requiredValue));
        return requiredValue.equals(possible);
    }

    private static Object stringToBoolean(String value) {
        return SqlBooleans.parseBooleanExact((String)value.trim()).map(Object.class::cast).orElse(NO_MATCH);
    }

    private static boolean arraysMatch(List<?> requiredValue, List<?> possibleMatch) {
        Iterator<?> rIt = requiredValue.iterator();
        Iterator<?> pIt = possibleMatch.iterator();
        while (rIt.hasNext() && pIt.hasNext()) {
            Object pNext;
            Object rNext = rIt.next();
            if (InListEvaluator.isStructuredMatch(rNext, pNext = pIt.next())) continue;
            return false;
        }
        return !rIt.hasNext() && !pIt.hasNext();
    }

    private static boolean mapsMatch(Map<?, ?> requiredValue, Map<?, ?> possibleMatch) {
        if (requiredValue.size() != possibleMatch.size()) {
            return false;
        }
        for (Map.Entry<?, ?> rEntry : requiredValue.entrySet()) {
            Object pValue = possibleMatch.get(rEntry.getKey());
            if (InListEvaluator.isStructuredMatch(rEntry.getValue(), pValue)) continue;
            return false;
        }
        return true;
    }

    private static boolean structsMatch(Struct requiredValue, Struct possibleMatch) {
        Schema rSchema = requiredValue.schema();
        Schema pSchema = possibleMatch.schema();
        if (rSchema.fields().size() != pSchema.fields().size()) {
            return false;
        }
        for (Field rField : rSchema.fields()) {
            Object pValue;
            Object rValue = requiredValue.get(rField);
            if (InListEvaluator.isStructuredMatch(rValue, pValue = possibleMatch.get(rField.name()))) continue;
            return false;
        }
        return true;
    }

    public static BigDecimal numberToDecimalValue(Number toConvert, Number toMatch) {
        return new BigDecimal(toConvert.toString()).setScale(((BigDecimal)toMatch).scale(), RoundingMode.UNNECESSARY);
    }

    private static <T> Handler handler(Class<T> type, TypeSafeHandler<T, T> handler) {
        return InListEvaluator.handler(type, type, handler);
    }

    private static <T0, T1> Handler handler(Class<T0> requiredType, Class<T1> possibleType, TypeSafeHandler<T0, T1> handler) {
        return (requiredValue, possibleMatch) -> {
            if (!requiredType.isAssignableFrom(requiredValue.getClass()) || !possibleType.isAssignableFrom(possibleMatch.getClass())) {
                return Optional.empty();
            }
            return Optional.of(handler.accept(requiredType.cast(requiredValue), possibleType.cast(possibleMatch)));
        };
    }

    private static interface Handler {
        public Optional<Boolean> accept(Object var1, Object var2);
    }

    private static interface TypeSafeHandler<T0, T1> {
        public boolean accept(T0 var1, T1 var2);
    }
}

