/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class ArithmeticUnaryExpression
extends Expression {
    private final Expression value;
    private final Sign sign;

    public ArithmeticUnaryExpression(Optional<NodeLocation> location, Sign sign, Expression value) {
        super(location);
        this.value = Objects.requireNonNull(value, "value");
        this.sign = Objects.requireNonNull(sign, "sign");
    }

    public static ArithmeticUnaryExpression positive(Optional<NodeLocation> location, Expression value) {
        return new ArithmeticUnaryExpression(location, Sign.PLUS, value);
    }

    public static ArithmeticUnaryExpression negative(Optional<NodeLocation> location, Expression value) {
        return new ArithmeticUnaryExpression(location, Sign.MINUS, value);
    }

    public Expression getValue() {
        return this.value;
    }

    public Sign getSign() {
        return this.sign;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitArithmeticUnary(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ArithmeticUnaryExpression that = (ArithmeticUnaryExpression)((Object)o);
        return Objects.equals((Object)this.value, (Object)that.value) && this.sign == that.sign;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.sign});
    }

    public static enum Sign {
        PLUS,
        MINUS;

    }
}

