/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class BetweenPredicate
extends Expression {
    private final Expression value;
    private final Expression min;
    private final Expression max;

    public BetweenPredicate(Expression value, Expression min, Expression max) {
        this(Optional.empty(), value, min, max);
    }

    public BetweenPredicate(Optional<NodeLocation> location, Expression value, Expression min, Expression max) {
        super(location);
        this.value = Objects.requireNonNull(value, "value");
        this.min = Objects.requireNonNull(min, "min");
        this.max = Objects.requireNonNull(max, "max");
    }

    public Expression getValue() {
        return this.value;
    }

    public Expression getMin() {
        return this.min;
    }

    public Expression getMax() {
        return this.max;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenPredicate(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)((Object)o);
        return Objects.equals((Object)this.value, (Object)that.value) && Objects.equals((Object)this.min, (Object)that.min) && Objects.equals((Object)this.max, (Object)that.max);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.min, this.max});
    }
}

