/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class CreateMapExpression
extends Expression {
    private final ImmutableMap<Expression, Expression> map;

    public CreateMapExpression(Optional<NodeLocation> location, Map<Expression, Expression> map) {
        super(location);
        this.map = ImmutableMap.copyOf(map);
    }

    public CreateMapExpression(Map<Expression, Expression> map) {
        this(Optional.empty(), map);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="map is ImmutableMap")
    public ImmutableMap<Expression, Expression> getMap() {
        return this.map;
    }

    @Override
    protected <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitCreateMapExpression(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CreateMapExpression that = (CreateMapExpression)((Object)o);
        return Objects.equals(this.map, that.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }
}

