/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.execution.expression.tree.InListExpression;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class InPredicate
extends Expression {
    private final Expression value;
    private final InListExpression valueList;

    public InPredicate(Expression value, InListExpression valueList) {
        this(Optional.empty(), value, valueList);
    }

    public InPredicate(Optional<NodeLocation> location, Expression value, InListExpression valueList) {
        super(location);
        this.value = Objects.requireNonNull(value, "value");
        this.valueList = Objects.requireNonNull(valueList, "valueList");
    }

    public Expression getValue() {
        return this.value;
    }

    public InListExpression getValueList() {
        return this.valueList;
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitInPredicate(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        InPredicate that = (InPredicate)((Object)o);
        return Objects.equals((Object)this.value, (Object)that.value) && Objects.equals((Object)this.valueList, (Object)that.valueList);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.value, this.valueList});
    }
}

