/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.expression.tree;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.expression.tree.ExpressionVisitor;
import io.confluent.ksql.parser.NodeLocation;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class SubscriptExpression
extends Expression {
    private final Expression base;
    private final Expression index;

    public SubscriptExpression(Expression base, Expression index) {
        this(Optional.empty(), base, index);
    }

    public SubscriptExpression(Optional<NodeLocation> location, Expression base, Expression index) {
        super(location);
        this.base = Objects.requireNonNull(base, "base");
        this.index = Objects.requireNonNull(index, "index");
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitSubscriptExpression(this, context);
    }

    public Expression getBase() {
        return this.base;
    }

    public Expression getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SubscriptExpression that = (SubscriptExpression)((Object)o);
        return Objects.equals((Object)this.base, (Object)that.base) && Objects.equals((Object)this.index, (Object)that.index);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.base, this.index});
    }
}

