/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.function.udtf;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.function.udtf.TableFunctionApplier;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@Immutable
public class KudtfFlatMapper<K>
implements KsqlTransformer<K, Iterable<GenericRow>> {
    @EffectivelyImmutable
    private final ProcessingLogger processingLogger;
    private final ImmutableList<TableFunctionApplier> tableFunctionAppliers;

    public KudtfFlatMapper(List<TableFunctionApplier> tableFunctionAppliers, ProcessingLogger processingLogger) {
        this.processingLogger = Objects.requireNonNull(processingLogger, "processingLogger");
        this.tableFunctionAppliers = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableFunctionAppliers, "tableFunctionAppliers"));
    }

    @Override
    public Iterable<GenericRow> transform(K readOnlyKey, GenericRow value) {
        if (value == null) {
            return null;
        }
        ArrayList iters = new ArrayList(this.tableFunctionAppliers.size());
        int maxLength = 0;
        for (TableFunctionApplier applier : this.tableFunctionAppliers) {
            List<?> exploded = applier.apply(value, this.processingLogger);
            iters.add(exploded.iterator());
            maxLength = Math.max(maxLength, exploded.size());
        }
        ArrayList<GenericRow> rows = new ArrayList<GenericRow>(maxLength);
        for (int i = 0; i < maxLength; ++i) {
            GenericRow newRow = new GenericRow(value.values().size() + iters.size());
            newRow.appendAll((Collection)value.values());
            for (Iterator iter : iters) {
                if (iter.hasNext()) {
                    newRow.append(iter.next());
                    continue;
                }
                newRow.append(null);
            }
            rows.add(newRow);
        }
        return rows;
    }
}

