/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.interpreter.InterpretedExpression;
import io.confluent.ksql.execution.interpreter.TermCompiler;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.execution.util.ExpressionTypeManager;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.KsqlConfig;
import io.confluent.ksql.util.KsqlException;
import io.confluent.ksql.util.KsqlStatementException;
import java.util.Objects;

public final class InterpretedExpressionFactory {
    private InterpretedExpressionFactory() {
    }

    public static InterpretedExpression create(Expression expression, LogicalSchema schema, FunctionRegistry functionRegistry, KsqlConfig ksqlConfig) {
        return InterpretedExpressionFactory.create(expression, schema, functionRegistry, ksqlConfig, new TermCompiler.Context());
    }

    @VisibleForTesting
    public static InterpretedExpression create(Expression expression, LogicalSchema schema, FunctionRegistry functionRegistry, KsqlConfig ksqlConfig, TermCompiler.Context context) {
        try {
            ExpressionTypeManager expressionTypeManager = new ExpressionTypeManager(schema, functionRegistry);
            SqlType returnType = expressionTypeManager.getExpressionSqlType(expression, context.getLambdaSqlTypeMapping());
            if (returnType == null) {
                throw new KsqlException("NULL expression not supported");
            }
            Term term = (Term)new TermCompiler(functionRegistry, schema, ksqlConfig, expressionTypeManager).process(expression, context);
            return new InterpretedExpression(expression, returnType, term);
        }
        catch (KsqlStatementException e) {
            throw new KsqlStatementException("Invalid expression: " + e.getMessage(), "Invalid expression: " + e.getUnloggedMessage() + ". expression: " + String.valueOf((Object)expression) + ", schema:" + String.valueOf(schema), Objects.toString((Object)expression), (Throwable)e);
        }
        catch (KsqlException e) {
            throw new KsqlStatementException("Invalid expression: " + e.getMessage(), "Invalid expression: " + e.getMessage() + ". expression: " + String.valueOf((Object)expression) + ", schema:" + String.valueOf(schema), Objects.toString((Object)expression), (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error generating code for expression: " + String.valueOf((Object)expression), e);
        }
    }
}

