/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;

public class CastTerm
implements Term {
    private final Term term;
    private final SqlType sqlType;
    private final CastFunction castFunction;

    public CastTerm(Term term, SqlType sqlType, CastFunction castFunction) {
        this.term = term;
        this.sqlType = sqlType;
        this.castFunction = castFunction;
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        Object value = this.term.getValue(context);
        if (value == null) {
            return null;
        }
        return this.castFunction.cast(value);
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public static interface CastFunction {
        public Object cast(Object var1);
    }

    public static interface ComparableCastFunction<T extends Comparable<T>>
    extends CastFunction {
        public T cast(Object var1);
    }
}

