/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.codegen.helpers.InListEvaluator;
import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.util.List;

public class InPredicateTerm
implements Term {
    private final Term value;
    private final List<Term> valueList;

    public InPredicateTerm(Term value, List<Term> valueList) {
        this.value = value;
        this.valueList = ImmutableList.copyOf(valueList);
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        Object[] values = this.valueList.stream().map(v -> v.getValue(context)).toArray();
        return InListEvaluator.matches(this.value.getValue(context), values);
    }

    @Override
    public SqlType getSqlType() {
        return SqlTypes.BOOLEAN;
    }
}

