/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.util.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LambdaFunctionTerms {
    private static Map<String, Object> createVariableMap(List<Pair<String, SqlType>> argNamesToTypes, Object ... args) {
        Preconditions.checkArgument((argNamesToTypes.size() == args.length ? 1 : 0) != 0, (Object)"Argument length should be the same");
        HashMap<String, Object> variableMap = new HashMap<String, Object>();
        int i = 0;
        for (Pair<String, SqlType> pair : argNamesToTypes) {
            String name = (String)pair.getLeft();
            variableMap.put(name, args[i]);
            ++i;
        }
        return Collections.unmodifiableMap(variableMap);
    }

    public static class LambdaFunction3Term
    extends LambdaFunctionBaseTerm {
        public LambdaFunction3Term(List<Pair<String, SqlType>> argNamesToTypes, Term body) {
            super(argNamesToTypes, body);
            Preconditions.checkState((argNamesToTypes.size() == 3 ? 1 : 0) != 0);
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return (arg0, arg1, arg3) -> this.getValueCommon(context, arg0, arg1, arg3);
        }
    }

    public static class LambdaFunction2Term
    extends LambdaFunctionBaseTerm {
        public LambdaFunction2Term(List<Pair<String, SqlType>> argNamesToTypes, Term body) {
            super(argNamesToTypes, body);
            Preconditions.checkState((argNamesToTypes.size() == 2 ? 1 : 0) != 0);
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return (arg0, arg1) -> this.getValueCommon(context, arg0, arg1);
        }
    }

    public static class LambdaFunction1Term
    extends LambdaFunctionBaseTerm {
        public LambdaFunction1Term(List<Pair<String, SqlType>> argNamesToTypes, Term body) {
            super(argNamesToTypes, body);
            Preconditions.checkState((argNamesToTypes.size() == 1 ? 1 : 0) != 0);
        }

        @Override
        public Object getValue(TermEvaluationContext context) {
            return arg0 -> this.getValueCommon(context, arg0);
        }
    }

    public static abstract class LambdaFunctionBaseTerm
    implements Term {
        protected final List<Pair<String, SqlType>> argNamesToTypes;
        protected final Term body;

        public LambdaFunctionBaseTerm(List<Pair<String, SqlType>> argNamesToTypes, Term body) {
            this.argNamesToTypes = ImmutableList.copyOf(argNamesToTypes);
            this.body = body;
        }

        @Override
        public SqlType getSqlType() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object getValueCommon(TermEvaluationContext context, Object ... args) {
            context.pushVariableMappings(LambdaFunctionTerms.createVariableMap(this.argNamesToTypes, args));
            try {
                Object object = this.body.getValue(context);
                return object;
            }
            finally {
                context.popVariableMappings();
            }
        }
    }
}

