/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.interpreter.terms;

import io.confluent.ksql.execution.codegen.helpers.LikeEvaluator;
import io.confluent.ksql.execution.interpreter.TermEvaluationContext;
import io.confluent.ksql.execution.interpreter.terms.Term;
import io.confluent.ksql.schema.ksql.types.SqlType;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import java.util.Optional;

public class LikeTerm
implements Term {
    private final Term patternString;
    private final Term valueString;
    private final Optional<Character> escapeChar;

    public LikeTerm(Term patternString, Term valueString, Optional<Character> escapeChar) {
        this.patternString = patternString;
        this.valueString = valueString;
        this.escapeChar = escapeChar;
    }

    @Override
    public Object getValue(TermEvaluationContext context) {
        return this.escapeChar.map(character -> LikeEvaluator.matches((String)this.valueString.getValue(context), (String)this.patternString.getValue(context), character.charValue())).orElseGet(() -> LikeEvaluator.matches((String)this.valueString.getValue(context), (String)this.patternString.getValue(context)));
    }

    @Override
    public SqlType getSqlType() {
        return SqlTypes.STRING;
    }
}

