/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericKey;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Objects;
import org.apache.kafka.streams.kstream.KGroupedStream;

@Immutable
public final class KGroupedStreamHolder {
    private final KGroupedStream<GenericKey, GenericRow> groupedStream;
    private final LogicalSchema schema;

    private KGroupedStreamHolder(KGroupedStream<GenericKey, GenericRow> groupedStream, LogicalSchema schema) {
        this.groupedStream = Objects.requireNonNull(groupedStream, "groupedStream");
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    public static KGroupedStreamHolder of(KGroupedStream<GenericKey, GenericRow> groupedStream, LogicalSchema schema) {
        return new KGroupedStreamHolder(groupedStream, schema);
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }

    public KGroupedStream<GenericKey, GenericRow> getGroupedStream() {
        return this.groupedStream;
    }
}

