/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.google.errorprone.annotations.Immutable;
import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.plan.ExecutionKeyFactory;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import java.util.Objects;
import org.apache.kafka.streams.kstream.KStream;

@Immutable
public final class KStreamHolder<K> {
    private final KStream<K, GenericRow> stream;
    private final ExecutionKeyFactory<K> executionKeyFactory;
    private final LogicalSchema schema;

    public KStreamHolder(KStream<K, GenericRow> stream, LogicalSchema schema, ExecutionKeyFactory<K> executionKeyFactory) {
        this.stream = Objects.requireNonNull(stream, "stream");
        this.executionKeyFactory = Objects.requireNonNull(executionKeyFactory, "keySerdeFactory");
        this.schema = Objects.requireNonNull(schema, "schema");
    }

    public ExecutionKeyFactory<K> getExecutionKeyFactory() {
        return this.executionKeyFactory;
    }

    public KStream<K, GenericRow> getStream() {
        return this.stream;
    }

    public KStreamHolder<K> withStream(KStream<K, GenericRow> stream, LogicalSchema schema) {
        return new KStreamHolder<K>(stream, schema, this.executionKeyFactory);
    }

    public LogicalSchema getSchema() {
        return this.schema;
    }
}

