/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.KStreamHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.name.ColumnName;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public class StreamSelect<K>
implements ExecutionStep<KStreamHolder<K>> {
    private final ExecutionStepPropertiesV1 properties;
    private final ExecutionStep<KStreamHolder<K>> source;
    private final ImmutableList<ColumnName> keyColumnNames;
    private final Optional<ImmutableList<ColumnName>> selectedKeys;
    private final ImmutableList<SelectExpression> selectExpressions;

    public StreamSelect(ExecutionStepPropertiesV1 props, ExecutionStep<KStreamHolder<K>> source, List<ColumnName> keyColumnNames, Optional<List<ColumnName>> selectedKeys, List<SelectExpression> selectExpressions) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.keyColumnNames = ImmutableList.copyOf(keyColumnNames);
        this.selectedKeys = selectedKeys.map(ImmutableList::copyOf);
        this.selectExpressions = ImmutableList.copyOf(selectExpressions);
        if (selectExpressions.isEmpty()) {
            throw new IllegalArgumentException("Need at least one select expression");
        }
    }

    @JsonCreator
    @Deprecated
    private StreamSelect(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<KStreamHolder<K>> source, @JsonProperty(value="keyColumnNames") Optional<List<ColumnName>> keyColumnNames, @JsonProperty(value="selectedKeys") Optional<List<ColumnName>> selectedKeys, @JsonProperty(value="selectExpressions", required=true) List<SelectExpression> selectExpressions) {
        this(props, source, keyColumnNames.orElseGet(ImmutableList::of), selectedKeys, selectExpressions);
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="keyColumnNames is ImmutableList")
    public List<ColumnName> getKeyColumnNames() {
        return this.keyColumnNames;
    }

    public Optional<ImmutableList<ColumnName>> getSelectedKeys() {
        return this.selectedKeys;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="selectExpressions is ImmutableList")
    public List<SelectExpression> getSelectExpressions() {
        return this.selectExpressions;
    }

    public ExecutionStep<KStreamHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KStreamHolder<K> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitStreamSelect(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitStreamSelect(this);
    }

    @Override
    public ExecutionStep.StepType type() {
        return ExecutionStep.StepType.PASSIVE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamSelect that = (StreamSelect)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.keyColumnNames, that.keyColumnNames) && Objects.equals(this.selectedKeys, that.selectedKeys) && Objects.equals(this.selectExpressions, that.selectExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.keyColumnNames, this.selectedKeys, this.selectExpressions);
    }
}

