/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.plan;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.plan.ExecutionStep;
import io.confluent.ksql.execution.plan.ExecutionStepPropertiesV1;
import io.confluent.ksql.execution.plan.Formats;
import io.confluent.ksql.execution.plan.KTableHolder;
import io.confluent.ksql.execution.plan.PlanBuilder;
import io.confluent.ksql.execution.plan.PlanInfo;
import io.confluent.ksql.execution.plan.PlanInfoExtractor;
import io.confluent.ksql.testing.EffectivelyImmutable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

@Immutable
public class TableSelectKey<K>
implements ExecutionStep<KTableHolder<K>> {
    private static final ImmutableList<ExecutionStep.Property> MUST_MATCH = ImmutableList.of((Object)new ExecutionStep.Property("class", Object::getClass), (Object)new ExecutionStep.Property("properties", ExecutionStep::getProperties), (Object)new ExecutionStep.Property("internal formats", t -> ((TableSelectKey)t).internalFormats), (Object)new ExecutionStep.Property("keyExpressions", t -> ((TableSelectKey)t).keyExpressions));
    private final ExecutionStepPropertiesV1 properties;
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private final ImmutableList<Expression> keyExpressions;
    @EffectivelyImmutable
    private final ExecutionStep<? extends KTableHolder<K>> source;
    private final Formats internalFormats;

    public TableSelectKey(@JsonProperty(value="properties", required=true) ExecutionStepPropertiesV1 props, @JsonProperty(value="source", required=true) ExecutionStep<? extends KTableHolder<K>> source, @JsonProperty(value="internalFormats", required=true) Formats internalFormats, @JsonProperty(value="keyExpression", required=true) List<Expression> keyExpressions) {
        this.properties = Objects.requireNonNull(props, "props");
        this.source = Objects.requireNonNull(source, "source");
        this.internalFormats = Objects.requireNonNull(internalFormats, "internalFormats");
        this.keyExpressions = ImmutableList.copyOf((Collection)Objects.requireNonNull(keyExpressions, "keyExpressions"));
    }

    @Override
    public ExecutionStepPropertiesV1 getProperties() {
        return this.properties;
    }

    @Override
    @JsonIgnore
    public List<ExecutionStep<?>> getSources() {
        return Collections.singletonList(this.source);
    }

    public Formats getInternalFormats() {
        return this.internalFormats;
    }

    @JsonProperty(value="keyExpression", required=true)
    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="keyExpressions is ImmutableList")
    public List<Expression> getKeyExpressions() {
        return this.keyExpressions;
    }

    public ExecutionStep<? extends KTableHolder<K>> getSource() {
        return this.source;
    }

    @Override
    public KTableHolder<K> build(PlanBuilder builder, PlanInfo info) {
        return builder.visitTableSelectKey(this, info);
    }

    @Override
    public PlanInfo extractPlanInfo(PlanInfoExtractor extractor) {
        return extractor.visitTableSelectKey(this);
    }

    @Override
    public void validateUpgrade(@Nonnull ExecutionStep<?> to) {
        this.mustMatch(to, (List<ExecutionStep.Property>)MUST_MATCH);
        this.getSource().validateUpgrade(((TableSelectKey)to).source);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableSelectKey that = (TableSelectKey)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.source, that.source) && Objects.equals(this.internalFormats, that.internalFormats) && Objects.equals(this.keyExpressions, that.keyExpressions);
    }

    public int hashCode() {
        return Objects.hash(this.properties, this.source, this.internalFormats, this.keyExpressions);
    }
}

