/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.transform.select;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.codegen.CompiledExpression;
import io.confluent.ksql.execution.plan.SelectExpression;
import io.confluent.ksql.execution.transform.ExpressionEvaluator;
import io.confluent.ksql.execution.transform.select.SelectValueMapper;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.util.KsqlConfig;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class SelectValueMapperFactory {
    private static final String EXP_TYPE = "Select";
    private final CodeGenRunner codeGenerator;

    @VisibleForTesting
    SelectValueMapperFactory(CodeGenRunner codeGenerator) {
        this.codeGenerator = Objects.requireNonNull(codeGenerator, "codeGenerator");
    }

    public static <K> SelectValueMapper<K> create(List<SelectExpression> selectExpressions, List<ExpressionEvaluator> compiledSelectExpressions) {
        return new SelectValueMapper(SelectValueMapperFactory.buildSelects(selectExpressions, compiledSelectExpressions));
    }

    public static <K> SelectValueMapper<K> create(List<SelectExpression> selectExpressions, LogicalSchema sourceSchema, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        CodeGenRunner codeGen = new CodeGenRunner(sourceSchema, ksqlConfig, functionRegistry);
        return new SelectValueMapperFactory(codeGen).create(selectExpressions);
    }

    @VisibleForTesting
    <K> SelectValueMapper<K> create(List<SelectExpression> selectExpressions) {
        return new SelectValueMapper(this.buildSelects(selectExpressions));
    }

    private SelectValueMapper.SelectInfo buildSelect(SelectExpression selectExpression) {
        CompiledExpression evaluator = this.codeGenerator.buildCodeGenFromParseTree(selectExpression.getExpression(), EXP_TYPE);
        return SelectValueMapper.SelectInfo.of(selectExpression.getAlias(), evaluator);
    }

    private List<SelectValueMapper.SelectInfo> buildSelects(List<SelectExpression> selectExpressions) {
        return selectExpressions.stream().map(this::buildSelect).collect(Collectors.toList());
    }

    private static List<SelectValueMapper.SelectInfo> buildSelects(List<SelectExpression> selectExpressions, List<ExpressionEvaluator> compiledSelectExpressions) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (int i = 0; i < selectExpressions.size(); ++i) {
            result.add((Object)SelectValueMapper.SelectInfo.of(selectExpressions.get(i).getAlias(), compiledSelectExpressions.get(i)));
        }
        return result.build();
    }

    @VisibleForTesting
    public static interface SelectValueMapperFactorySupplier {
        public <K> SelectValueMapper<K> create(List<SelectExpression> var1, List<ExpressionEvaluator> var2);
    }
}

