/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.execution.transform.sqlpredicate;

import io.confluent.ksql.GenericRow;
import io.confluent.ksql.execution.codegen.CodeGenRunner;
import io.confluent.ksql.execution.expression.tree.Expression;
import io.confluent.ksql.execution.transform.ExpressionEvaluator;
import io.confluent.ksql.execution.transform.KsqlTransformer;
import io.confluent.ksql.function.FunctionRegistry;
import io.confluent.ksql.logging.processing.ProcessingLogger;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.schema.ksql.types.SqlTypes;
import io.confluent.ksql.util.KsqlConfig;
import java.util.Objects;
import java.util.Optional;

public final class SqlPredicate {
    private final Expression filterExpression;
    private final ExpressionEvaluator evaluator;

    public SqlPredicate(Expression filterExpression, LogicalSchema schema, KsqlConfig ksqlConfig, FunctionRegistry functionRegistry) {
        this(filterExpression, CodeGenRunner.compileExpression(filterExpression, "Predicate", schema, ksqlConfig, functionRegistry));
    }

    public SqlPredicate(Expression filterExpression, ExpressionEvaluator evaluator) {
        this.filterExpression = Objects.requireNonNull(filterExpression, "filterExpression");
        this.evaluator = Objects.requireNonNull(evaluator, "evaluator");
        if (!evaluator.getExpressionType().equals(SqlTypes.BOOLEAN)) {
            throw new IllegalArgumentException("Filter expression must resolve to boolean: " + String.valueOf((Object)filterExpression));
        }
    }

    public <K> KsqlTransformer<K, Optional<GenericRow>> getTransformer(ProcessingLogger processingLogger) {
        return new Transformer(processingLogger);
    }

    private final class Transformer<K>
    implements KsqlTransformer<K, Optional<GenericRow>> {
        private final ProcessingLogger processingLogger;
        private final String errorMsg;

        Transformer(ProcessingLogger processingLogger) {
            this.processingLogger = Objects.requireNonNull(processingLogger, "processingLogger");
            this.errorMsg = "Error evaluating predicate " + SqlPredicate.this.filterExpression.toString();
        }

        @Override
        public Optional<GenericRow> transform(K readOnlyKey, GenericRow value) {
            if (value == null) {
                return Optional.empty();
            }
            boolean result = (Boolean)SqlPredicate.this.evaluator.evaluate(value, false, this.processingLogger, () -> this.errorMsg);
            return result ? Optional.of(value) : Optional.empty();
        }
    }
}

