/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.schema.query;

import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.confluent.ksql.schema.ksql.LogicalSchema;
import io.confluent.ksql.serde.KeyFormat;
import io.confluent.ksql.serde.ValueFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class QuerySchemas {
    private final LinkedHashMap<String, SchemaInfo> loggerToSchemas = new LinkedHashMap();
    private final Map<String, Map<Boolean, Set<String>>> topicsToLoggers = new HashMap<String, Map<Boolean, Set<String>>>();
    private static final boolean IS_KEY_SCHEMA = true;
    private static final boolean IS_VALUE_SCHEMA = false;

    public void trackKeySerdeCreation(String loggerNamePrefix, LogicalSchema schema, KeyFormat keyFormat) {
        this.trackSerde(loggerNamePrefix, schema, Optional.of(keyFormat), Optional.empty());
    }

    public void trackValueSerdeCreation(String loggerNamePrefix, LogicalSchema schema, ValueFormat valueFormat) {
        this.trackSerde(loggerNamePrefix, schema, Optional.empty(), Optional.of(valueFormat));
    }

    public synchronized void trackSerdeOp(String topicName, boolean key, String loggerNamePrefix) {
        this.topicsToLoggers.computeIfAbsent(topicName, k1 -> new HashMap()).computeIfAbsent(key, k -> new HashSet()).add(loggerNamePrefix);
    }

    public Map<String, SchemaInfo> getLoggerSchemaInfo() {
        return Collections.unmodifiableMap(this.loggerToSchemas);
    }

    Map<String, Map<Boolean, Set<String>>> getTopicsToLoggers() {
        return Collections.unmodifiableMap(this.topicsToLoggers);
    }

    public MultiSchemaInfo getTopicInfo(String topicName) {
        Set<SchemaInfo> keySchemasInfo = this.getTopicSchemas(topicName, true);
        Set<SchemaInfo> valueSchemasInfo = this.getTopicSchemas(topicName, false);
        return new MultiSchemaInfo(keySchemasInfo, valueSchemasInfo);
    }

    private Set<SchemaInfo> getTopicSchemas(String topicName, boolean isKeySchema) {
        Map<Boolean, Set<String>> kvLoggerNames = this.topicsToLoggers.get(topicName);
        if (kvLoggerNames == null) {
            throw new IllegalArgumentException("Unknown topic: " + topicName);
        }
        HashMap<SchemaInfo, Set> schemaToLoggers = new HashMap<SchemaInfo, Set>();
        for (String loggerName : kvLoggerNames.getOrDefault(isKeySchema, (Set<String>)ImmutableSet.of())) {
            SchemaInfo schemaInfo = this.loggerToSchemas.get(loggerName);
            if (schemaInfo == null) continue;
            schemaToLoggers.computeIfAbsent(schemaInfo, k -> new HashSet()).add(loggerName);
        }
        return schemaToLoggers.keySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QuerySchemas that = (QuerySchemas)o;
        return Objects.equals(this.loggerToSchemas, that.loggerToSchemas) && Objects.equals(this.topicsToLoggers, that.topicsToLoggers);
    }

    public int hashCode() {
        return Objects.hash(this.loggerToSchemas, this.topicsToLoggers);
    }

    private void trackSerde(String loggerNamePrefix, LogicalSchema schema, Optional<KeyFormat> keyFormat, Optional<ValueFormat> valueFormat) {
        this.loggerToSchemas.compute(loggerNamePrefix, (k, existing) -> {
            if (existing == null) {
                return new SchemaInfo(schema, keyFormat, valueFormat);
            }
            if (!existing.schema.equals((Object)schema)) {
                throw new IllegalStateException("Inconsistent schema: existing: " + String.valueOf(existing.schema) + ", new: " + String.valueOf(schema));
            }
            return existing.merge(keyFormat, valueFormat);
        });
    }

    public static class MultiSchemaInfo {
        private final Set<SchemaInfo> keySchemas;
        private final Set<SchemaInfo> valueSchemas;
        private final Set<KeyFormat> keyFormats;
        private final Set<ValueFormat> valueFormats;

        public MultiSchemaInfo(Set<SchemaInfo> keySchemas, Set<SchemaInfo> valueSchemas) {
            this.keySchemas = ImmutableSet.copyOf((Collection)Objects.requireNonNull(keySchemas, "keySchemas"));
            this.valueSchemas = ImmutableSet.copyOf((Collection)Objects.requireNonNull(valueSchemas, "valuesSchemas"));
            this.keyFormats = ImmutableSet.copyOf((Collection)keySchemas.stream().map(SchemaInfo::keyFormat).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
            this.valueFormats = ImmutableSet.copyOf((Collection)valueSchemas.stream().map(SchemaInfo::valueFormat).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet()));
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="keySchemas is ImmutableSet")
        public Set<SchemaInfo> getKeySchemas() {
            return this.keySchemas;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="valueSchemas is ImmutableSet")
        public Set<SchemaInfo> getValueSchemas() {
            return this.valueSchemas;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="keyFormats is ImmutableSet")
        public Set<KeyFormat> getKeyFormats() {
            return this.keyFormats;
        }

        @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="valueFormats is ImmutableSet")
        public Set<ValueFormat> getValueFormats() {
            return this.valueFormats;
        }
    }

    @Immutable
    public static final class SchemaInfo {
        private final LogicalSchema schema;
        private final Optional<KeyFormat> keyFormat;
        private final Optional<ValueFormat> valueFormat;

        public SchemaInfo(LogicalSchema schema, Optional<KeyFormat> keyFormat, Optional<ValueFormat> valueFormat) {
            this.schema = Objects.requireNonNull(schema, "schema");
            this.keyFormat = Objects.requireNonNull(keyFormat, "keyFormat");
            this.valueFormat = Objects.requireNonNull(valueFormat, "valueFormat");
        }

        public String toString() {
            return "schema=" + String.valueOf(this.schema) + ", keyFormat=" + this.keyFormat.map(Object::toString).orElse("?") + ", valueFormat=" + this.valueFormat.map(Object::toString).orElse("?");
        }

        public LogicalSchema schema() {
            return this.schema;
        }

        public Optional<KeyFormat> keyFormat() {
            return this.keyFormat;
        }

        public Optional<ValueFormat> valueFormat() {
            return this.valueFormat;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemaInfo that = (SchemaInfo)o;
            return Objects.equals(this.schema, that.schema) && Objects.equals(this.keyFormat, that.keyFormat) && Objects.equals(this.valueFormat, that.valueFormat);
        }

        public int hashCode() {
            return Objects.hash(this.schema, this.keyFormat, this.valueFormat);
        }

        SchemaInfo merge(Optional<KeyFormat> keyFormat, Optional<ValueFormat> valueFormat) {
            if (this.keyFormat.isPresent() && keyFormat.isPresent()) {
                throw new IllegalStateException("key format already set");
            }
            if (this.valueFormat.isPresent() && valueFormat.isPresent()) {
                throw new IllegalStateException("value format already set");
            }
            return new SchemaInfo(this.schema, keyFormat.isPresent() ? keyFormat : this.keyFormat, valueFormat.isPresent() ? valueFormat : this.valueFormat);
        }
    }
}

