/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.services;

import io.confluent.ksql.rest.entity.ConfigInfos;
import io.confluent.ksql.rest.entity.ConnectorInfo;
import io.confluent.ksql.rest.entity.ConnectorStateInfo;
import io.confluent.ksql.rest.entity.SimpleConnectorPluginInfo;
import io.confluent.ksql.util.KsqlPreconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface ConnectClient {
    public ConnectResponse<List<String>> connectors();

    public ConnectResponse<List<SimpleConnectorPluginInfo>> connectorPlugins();

    public ConnectResponse<ConnectorInfo> describe(String var1);

    public ConnectResponse<ConnectorInfo> create(String var1, Map<String, String> var2);

    public ConnectResponse<ConfigInfos> validate(String var1, Map<String, String> var2);

    public ConnectResponse<ConnectorStateInfo> status(String var1);

    public ConnectResponse<String> delete(String var1);

    public ConnectResponse<Map<String, Map<String, List<String>>>> topics(String var1);

    public static class ConnectResponse<T> {
        private final Optional<T> datum;
        private final Optional<String> error;
        private final int httpCode;

        public static <T> ConnectResponse<T> success(T datum, int code) {
            return new ConnectResponse<T>(datum, null, code);
        }

        public static <T> ConnectResponse<T> failure(String error, int code) {
            return new ConnectResponse<Object>(null, error, code);
        }

        private ConnectResponse(T datum, String error, int code) {
            KsqlPreconditions.checkArgument((boolean)(datum != null ^ error != null), (String)"expected exactly one of datum or error to be null");
            this.datum = Optional.ofNullable(datum);
            this.error = Optional.ofNullable(error);
            this.httpCode = code;
        }

        public Optional<T> datum() {
            return this.datum;
        }

        public Optional<String> error() {
            return this.error;
        }

        public int httpCode() {
            return this.httpCode;
        }
    }
}

