/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.internals.Plugin;
import org.apache.kafka.common.message.AlterShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.AlterShareGroupOffsetsResponseData;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ConsumerGroupHeartbeatResponseData;
import org.apache.kafka.common.message.DeleteGroupsResponseData;
import org.apache.kafka.common.message.DeleteShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.DeleteShareGroupOffsetsResponseData;
import org.apache.kafka.common.message.DeleteShareGroupStateRequestData;
import org.apache.kafka.common.message.DescribeGroupsResponseData;
import org.apache.kafka.common.message.HeartbeatRequestData;
import org.apache.kafka.common.message.HeartbeatResponseData;
import org.apache.kafka.common.message.JoinGroupRequestData;
import org.apache.kafka.common.message.JoinGroupResponseData;
import org.apache.kafka.common.message.LeaveGroupRequestData;
import org.apache.kafka.common.message.LeaveGroupResponseData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.ShareGroupDescribeResponseData;
import org.apache.kafka.common.message.ShareGroupHeartbeatRequestData;
import org.apache.kafka.common.message.ShareGroupHeartbeatResponseData;
import org.apache.kafka.common.message.StreamsGroupDescribeResponseData;
import org.apache.kafka.common.message.StreamsGroupHeartbeatRequestData;
import org.apache.kafka.common.message.SyncGroupRequestData;
import org.apache.kafka.common.message.SyncGroupResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorExecutor;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetrics;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.common.runtime.CoordinatorShard;
import org.apache.kafka.coordinator.common.runtime.CoordinatorShardBuilder;
import org.apache.kafka.coordinator.common.runtime.CoordinatorTimer;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupConfigManager;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupMetadataManager;
import org.apache.kafka.coordinator.group.OffsetMetadataManager;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupPartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupRegularExpressionValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.CoordinatorRecordType;
import org.apache.kafka.coordinator.group.generated.GroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.GroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.LegacyOffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.LegacyOffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupStatePartitionMetadataValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.ShareGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupCurrentMemberAssignmentKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupCurrentMemberAssignmentValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMemberMetadataKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMetadataKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMemberKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMemberValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMetadataKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTargetAssignmentMetadataValue;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTopologyKey;
import org.apache.kafka.coordinator.group.generated.StreamsGroupTopologyValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetrics;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.coordinator.group.streams.StreamsGroupHeartbeatResult;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.metadata.MetadataEncryptorFactory;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.Authorizer;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.share.persister.DeleteShareGroupStateParameters;
import org.apache.kafka.server.share.persister.InitializeShareGroupStateParameters;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.slf4j.Logger;

public class GroupCoordinatorShard
implements CoordinatorShard<CoordinatorRecord> {
    static final String GROUP_EXPIRATION_KEY = "expire-group-metadata";
    static final String GROUP_METRICS_UPDATE_KEY = "group-metrics-update-task";
    static final int DEFAULT_GROUP_GAUGES_UPDATE_INTERVAL_MS = 60000;
    private final Logger log;
    private final GroupMetadataManager groupMetadataManager;
    private final OffsetMetadataManager offsetMetadataManager;
    private final Time time;
    private final CoordinatorTimer<Void, CoordinatorRecord> timer;
    private final GroupCoordinatorConfig config;
    private final CoordinatorMetrics coordinatorMetrics;
    private final CoordinatorMetricsShard metricsShard;

    GroupCoordinatorShard(LogContext logContext, GroupMetadataManager groupMetadataManager, OffsetMetadataManager offsetMetadataManager, Time time, CoordinatorTimer<Void, CoordinatorRecord> timer, GroupCoordinatorConfig config, CoordinatorMetrics coordinatorMetrics, CoordinatorMetricsShard metricsShard) {
        this.log = logContext.logger(GroupCoordinatorShard.class);
        this.groupMetadataManager = groupMetadataManager;
        this.offsetMetadataManager = offsetMetadataManager;
        this.time = time;
        this.timer = timer;
        this.config = config;
        this.coordinatorMetrics = coordinatorMetrics;
        this.metricsShard = metricsShard;
    }

    public CoordinatorResult<ConsumerGroupHeartbeatResponseData, CoordinatorRecord> consumerGroupHeartbeat(AuthorizableRequestContext context, ConsumerGroupHeartbeatRequestData request) {
        return this.groupMetadataManager.consumerGroupHeartbeat(context, request);
    }

    public CoordinatorResult<StreamsGroupHeartbeatResult, CoordinatorRecord> streamsGroupHeartbeat(AuthorizableRequestContext context, StreamsGroupHeartbeatRequestData request) {
        return this.groupMetadataManager.streamsGroupHeartbeat(context, request);
    }

    public CoordinatorResult<Map.Entry<ShareGroupHeartbeatResponseData, Optional<InitializeShareGroupStateParameters>>, CoordinatorRecord> shareGroupHeartbeat(AuthorizableRequestContext context, ShareGroupHeartbeatRequestData request) {
        return this.groupMetadataManager.shareGroupHeartbeat(context, request);
    }

    public CoordinatorResult<Void, CoordinatorRecord> initializeShareGroupState(String groupId, Map<Uuid, Set<Integer>> topicPartitionMap) {
        return this.groupMetadataManager.initializeShareGroupState(groupId, topicPartitionMap);
    }

    public CoordinatorResult<Void, CoordinatorRecord> uninitializeShareGroupState(String groupId, Map<Uuid, Set<Integer>> topicPartitionMap) {
        return this.groupMetadataManager.uninitializeShareGroupState(groupId, topicPartitionMap);
    }

    public Map<Uuid, Set<Integer>> initializedShareGroupPartitions(String groupId) {
        return this.groupMetadataManager.initializedShareGroupPartitions(groupId);
    }

    public CoordinatorResult<Void, CoordinatorRecord> classicGroupJoin(AuthorizableRequestContext context, JoinGroupRequestData request, CompletableFuture<JoinGroupResponseData> responseFuture) {
        return this.groupMetadataManager.classicGroupJoin(context, request, responseFuture);
    }

    public CoordinatorResult<Void, CoordinatorRecord> classicGroupSync(AuthorizableRequestContext context, SyncGroupRequestData request, CompletableFuture<SyncGroupResponseData> responseFuture) {
        return this.groupMetadataManager.classicGroupSync(context, request, responseFuture);
    }

    public CoordinatorResult<HeartbeatResponseData, CoordinatorRecord> classicGroupHeartbeat(AuthorizableRequestContext context, HeartbeatRequestData request) {
        return this.groupMetadataManager.classicGroupHeartbeat(context, request);
    }

    public CoordinatorResult<DeleteGroupsResponseData.DeletableGroupResultCollection, CoordinatorRecord> deleteGroups(AuthorizableRequestContext context, List<String> groupIds) throws ApiException {
        DeleteGroupsResponseData.DeletableGroupResultCollection resultCollection = new DeleteGroupsResponseData.DeletableGroupResultCollection(groupIds.size());
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        int numDeletedOffsets = 0;
        ArrayList<String> deletedGroups = new ArrayList<String>();
        for (String groupId : groupIds) {
            try {
                this.groupMetadataManager.validateDeleteGroup(groupId);
                numDeletedOffsets += this.offsetMetadataManager.deleteAllOffsets(groupId, records);
                this.groupMetadataManager.createGroupTombstoneRecords(groupId, records);
                deletedGroups.add(groupId);
                resultCollection.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId));
            }
            catch (ApiException exception) {
                resultCollection.add((ImplicitLinkedHashCollection.Element)new DeleteGroupsResponseData.DeletableGroupResult().setGroupId(groupId).setErrorCode(Errors.forException((Throwable)exception).code()));
            }
        }
        this.log.info("The following groups were deleted: {}. A total of {} offsets were removed.", (Object)String.join((CharSequence)", ", deletedGroups), (Object)numDeletedOffsets);
        return new CoordinatorResult(records, (Object)resultCollection);
    }

    public CoordinatorResult<Map<String, Map.Entry<DeleteShareGroupStateParameters, Errors>>, CoordinatorRecord> sharePartitionDeleteRequests(List<String> groupIds) {
        HashMap<String, Map.Entry<DeleteShareGroupStateParameters, Errors>> responseMap = new HashMap<String, Map.Entry<DeleteShareGroupStateParameters, Errors>>();
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        for (String groupId : groupIds) {
            try {
                ShareGroup group = this.groupMetadataManager.shareGroup(groupId);
                group.validateDeleteGroup();
                this.groupMetadataManager.shareGroupBuildPartitionDeleteRequest(groupId, records).ifPresent(req -> responseMap.put(groupId, Map.entry(req, Errors.NONE)));
            }
            catch (GroupIdNotFoundException exception) {
                this.log.debug("Unable to delete share group. GroupId {} not found.", (Object)groupId);
            }
            catch (GroupNotEmptyException exception) {
                this.log.debug("Unable to delete share group. Provided group {} is not empty.", (Object)groupId);
                responseMap.put(groupId, Map.entry(DeleteShareGroupStateParameters.EMPTY_PARAMS, Errors.forException((Throwable)exception)));
            }
        }
        return new CoordinatorResult(records, responseMap);
    }

    public CoordinatorResult<DeleteShareGroupOffsetsResultHolder, CoordinatorRecord> initiateDeleteShareGroupOffsets(String groupId, DeleteShareGroupOffsetsRequestData requestData) {
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        try {
            ShareGroup group = this.groupMetadataManager.shareGroup(groupId);
            group.validateDeleteGroup();
            ArrayList<DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic> errorTopicResponseList = new ArrayList<DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic>();
            List<DeleteShareGroupStateRequestData.DeleteStateData> deleteShareGroupStateRequestTopicsData = this.groupMetadataManager.sharePartitionsEligibleForOffsetDeletion(groupId, requestData, errorTopicResponseList, records);
            if (deleteShareGroupStateRequestTopicsData.isEmpty()) {
                return new CoordinatorResult(records, (Object)new DeleteShareGroupOffsetsResultHolder(Errors.NONE.code(), null, errorTopicResponseList));
            }
            DeleteShareGroupStateRequestData deleteShareGroupStateRequestData = new DeleteShareGroupStateRequestData().setGroupId(requestData.groupId()).setTopics(deleteShareGroupStateRequestTopicsData);
            return new CoordinatorResult(records, (Object)new DeleteShareGroupOffsetsResultHolder(Errors.NONE.code(), null, errorTopicResponseList, DeleteShareGroupStateParameters.from((DeleteShareGroupStateRequestData)deleteShareGroupStateRequestData)));
        }
        catch (GroupIdNotFoundException exception) {
            this.log.debug("Unable to delete share group offsets. GroupId {} not found.", (Object)groupId);
            return new CoordinatorResult(records, (Object)new DeleteShareGroupOffsetsResultHolder(Errors.GROUP_ID_NOT_FOUND.code(), exception.getMessage()));
        }
        catch (GroupNotEmptyException exception) {
            this.log.debug("Unable to delete share group offsets. Provided group {} is not empty.", (Object)groupId);
            return new CoordinatorResult(records, (Object)new DeleteShareGroupOffsetsResultHolder(Errors.NON_EMPTY_GROUP.code(), exception.getMessage()));
        }
    }

    public CoordinatorResult<DeleteShareGroupOffsetsResponseData, CoordinatorRecord> completeDeleteShareGroupOffsets(String groupId, Map<Uuid, String> topics, List<DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic> errorTopicResponseList) {
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        ArrayList<DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic> topicResponseList = new ArrayList<DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic>();
        topicResponseList.addAll(this.groupMetadataManager.completeDeleteShareGroupOffsets(groupId, topics, records));
        topicResponseList.addAll(errorTopicResponseList);
        return new CoordinatorResult(records, (Object)new DeleteShareGroupOffsetsResponseData().setErrorCode(Errors.NONE.code()).setErrorMessage(null).setResponses(topicResponseList));
    }

    public CoordinatorResult<Map.Entry<AlterShareGroupOffsetsResponseData, InitializeShareGroupStateParameters>, CoordinatorRecord> alterShareGroupOffsets(String groupId, AlterShareGroupOffsetsRequestData alterShareGroupOffsetsRequestData) {
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        ShareGroup group = this.groupMetadataManager.shareGroup(groupId);
        group.validateOffsetsAlterable();
        Map.Entry<AlterShareGroupOffsetsResponseData, InitializeShareGroupStateParameters> response = this.groupMetadataManager.completeAlterShareGroupOffsets(groupId, alterShareGroupOffsetsRequestData, records);
        return new CoordinatorResult(records, response);
    }

    public OffsetFetchResponseData.OffsetFetchResponseGroup fetchOffsets(OffsetFetchRequestData.OffsetFetchRequestGroup request, long epoch) throws ApiException {
        return this.offsetMetadataManager.fetchOffsets(request, epoch);
    }

    public OffsetFetchResponseData.OffsetFetchResponseGroup fetchAllOffsets(OffsetFetchRequestData.OffsetFetchRequestGroup request, long epoch) throws ApiException {
        return this.offsetMetadataManager.fetchAllOffsets(request, epoch);
    }

    public CoordinatorResult<OffsetCommitResponseData, CoordinatorRecord> commitOffset(AuthorizableRequestContext context, OffsetCommitRequestData request) throws ApiException {
        return this.offsetMetadataManager.commitOffset(context, request);
    }

    public CoordinatorResult<TxnOffsetCommitResponseData, CoordinatorRecord> commitTransactionalOffset(AuthorizableRequestContext context, TxnOffsetCommitRequestData request) throws ApiException {
        return this.offsetMetadataManager.commitTransactionalOffset(context, request);
    }

    public List<ListGroupsResponseData.ListedGroup> listGroups(List<String> statesFilter, List<String> typesFilter, long committedOffset) throws ApiException {
        HashSet<String> statesFilterSet = new HashSet<String>(statesFilter);
        HashSet<String> typesFilterSet = new HashSet<String>(typesFilter);
        return this.groupMetadataManager.listGroups(statesFilterSet, typesFilterSet, committedOffset);
    }

    public List<ConsumerGroupDescribeResponseData.DescribedGroup> consumerGroupDescribe(List<String> groupIds, long committedOffset) {
        return this.groupMetadataManager.consumerGroupDescribe(groupIds, committedOffset);
    }

    public List<StreamsGroupDescribeResponseData.DescribedGroup> streamsGroupDescribe(List<String> groupIds, long committedOffset) {
        return this.groupMetadataManager.streamsGroupDescribe(groupIds, committedOffset);
    }

    public List<ShareGroupDescribeResponseData.DescribedGroup> shareGroupDescribe(List<String> groupIds, long committedOffset) {
        return this.groupMetadataManager.shareGroupDescribe(groupIds, committedOffset);
    }

    public List<DescribeGroupsResponseData.DescribedGroup> describeGroups(AuthorizableRequestContext context, List<String> groupIds, long committedOffset) {
        return this.groupMetadataManager.describeGroups(context, groupIds, committedOffset);
    }

    public CoordinatorResult<LeaveGroupResponseData, CoordinatorRecord> classicGroupLeave(AuthorizableRequestContext context, LeaveGroupRequestData request) throws ApiException {
        return this.groupMetadataManager.classicGroupLeave(context, request);
    }

    public CoordinatorResult<OffsetDeleteResponseData, CoordinatorRecord> deleteOffsets(AuthorizableRequestContext context, OffsetDeleteRequestData request) throws ApiException {
        return this.offsetMetadataManager.deleteOffsets(request);
    }

    public CoordinatorResult<Void, CoordinatorRecord> cleanupGroupMetadata() {
        long startMs = this.time.milliseconds();
        ArrayList records = new ArrayList();
        this.groupMetadataManager.groupIds().forEach(groupId -> {
            boolean allOffsetsExpired;
            Group group = this.groupMetadataManager.group((String)groupId);
            if (group.shouldExpire() && (allOffsetsExpired = this.offsetMetadataManager.cleanupExpiredOffsets((String)groupId, records))) {
                this.groupMetadataManager.maybeDeleteGroup((String)groupId, records);
            }
        });
        if (!records.isEmpty()) {
            this.log.info("Generated {} tombstone records while cleaning up group metadata in {} milliseconds.", (Object)records.size(), (Object)(this.time.milliseconds() - startMs));
        }
        this.scheduleGroupMetadataExpiration();
        return new CoordinatorResult(records, false);
    }

    private void scheduleGroupMetadataExpiration() {
        this.timer.schedule(GROUP_EXPIRATION_KEY, this.config.offsetsRetentionCheckIntervalMs(), TimeUnit.MILLISECONDS, true, this.config.offsetsRetentionCheckIntervalMs(), this::cleanupGroupMetadata);
    }

    public CoordinatorResult<Void, CoordinatorRecord> onPartitionsDeleted(List<TopicPartition> topicPartitions) {
        long startTimeMs = this.time.milliseconds();
        List<CoordinatorRecord> records = this.offsetMetadataManager.onPartitionsDeleted(topicPartitions);
        this.log.info("Generated {} tombstone records in {} milliseconds while deleting offsets for partitions {}.", new Object[]{records.size(), this.time.milliseconds() - startTimeMs, topicPartitions});
        return new CoordinatorResult(records, false);
    }

    public CoordinatorResult<Void, CoordinatorRecord> maybeCleanupShareGroupState(Set<Uuid> deletedTopicIds) {
        return this.groupMetadataManager.maybeCleanupShareGroupState(deletedTopicIds);
    }

    private void scheduleGroupMetricsUpdateTask() {
        this.timer.schedule(GROUP_METRICS_UPDATE_KEY, 60000L, TimeUnit.MILLISECONDS, true, () -> {
            this.groupMetadataManager.updateGroupMetrics();
            this.scheduleGroupMetricsUpdateTask();
            return GroupMetadataManager.EMPTY_RESULT;
        });
    }

    private void cancelGroupMetricsUpdateTask() {
        this.timer.cancel(GROUP_METRICS_UPDATE_KEY);
    }

    public void onLoaded(MetadataImage newImage) {
        MetadataDelta emptyDelta = new MetadataDelta(newImage, __ -> null, new MetadataEncryptorFactory());
        this.groupMetadataManager.onNewMetadataImage(newImage, emptyDelta);
        this.coordinatorMetrics.activateMetricsShard(this.metricsShard);
        this.groupMetadataManager.onLoaded();
        this.scheduleGroupMetadataExpiration();
        this.scheduleGroupMetricsUpdateTask();
    }

    public void onUnloaded() {
        this.timer.cancel(GROUP_EXPIRATION_KEY);
        this.coordinatorMetrics.deactivateMetricsShard(this.metricsShard);
        this.groupMetadataManager.onUnloaded();
        this.cancelGroupMetricsUpdateTask();
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.groupMetadataManager.onNewMetadataImage(newImage, delta);
    }

    private static OffsetCommitKey convertLegacyOffsetCommitKey(LegacyOffsetCommitKey key) {
        return new OffsetCommitKey().setGroup(key.group()).setTopic(key.topic()).setPartition(key.partition());
    }

    private static OffsetCommitValue convertLegacyOffsetCommitValue(LegacyOffsetCommitValue value) {
        if (value == null) {
            return null;
        }
        return new OffsetCommitValue().setOffset(value.offset()).setCommitTimestamp(value.commitTimestamp()).setMetadata(value.metadata());
    }

    public void replay(long offset, long producerId, short producerEpoch, CoordinatorRecord record) throws RuntimeException {
        CoordinatorRecordType recordType;
        ApiMessage key = record.key();
        ApiMessageAndVersion value = record.value();
        try {
            recordType = CoordinatorRecordType.fromId(key.apiKey());
        }
        catch (UnsupportedVersionException ex) {
            throw new IllegalStateException("Received an unknown record type " + key.apiKey() + " in " + String.valueOf(record), ex);
        }
        switch (recordType) {
            case LEGACY_OFFSET_COMMIT: {
                this.offsetMetadataManager.replay(offset, producerId, GroupCoordinatorShard.convertLegacyOffsetCommitKey((LegacyOffsetCommitKey)key), GroupCoordinatorShard.convertLegacyOffsetCommitValue((LegacyOffsetCommitValue)Utils.messageOrNull(value)));
                break;
            }
            case OFFSET_COMMIT: {
                this.offsetMetadataManager.replay(offset, producerId, (OffsetCommitKey)key, (OffsetCommitValue)Utils.messageOrNull(value));
                break;
            }
            case GROUP_METADATA: {
                this.groupMetadataManager.replay((GroupMetadataKey)key, (GroupMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case CONSUMER_GROUP_METADATA: {
                this.groupMetadataManager.replay((ConsumerGroupMetadataKey)key, (ConsumerGroupMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case CONSUMER_GROUP_PARTITION_METADATA: {
                this.groupMetadataManager.replay((ConsumerGroupPartitionMetadataKey)key, (ConsumerGroupPartitionMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case CONSUMER_GROUP_MEMBER_METADATA: {
                this.groupMetadataManager.replay((ConsumerGroupMemberMetadataKey)key, (ConsumerGroupMemberMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case CONSUMER_GROUP_TARGET_ASSIGNMENT_METADATA: {
                this.groupMetadataManager.replay((ConsumerGroupTargetAssignmentMetadataKey)key, (ConsumerGroupTargetAssignmentMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case CONSUMER_GROUP_TARGET_ASSIGNMENT_MEMBER: {
                this.groupMetadataManager.replay((ConsumerGroupTargetAssignmentMemberKey)key, (ConsumerGroupTargetAssignmentMemberValue)Utils.messageOrNull(value));
                break;
            }
            case CONSUMER_GROUP_CURRENT_MEMBER_ASSIGNMENT: {
                this.groupMetadataManager.replay((ConsumerGroupCurrentMemberAssignmentKey)key, (ConsumerGroupCurrentMemberAssignmentValue)Utils.messageOrNull(value));
                break;
            }
            case SHARE_GROUP_MEMBER_METADATA: {
                this.groupMetadataManager.replay((ShareGroupMemberMetadataKey)key, (ShareGroupMemberMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case SHARE_GROUP_METADATA: {
                this.groupMetadataManager.replay((ShareGroupMetadataKey)key, (ShareGroupMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case SHARE_GROUP_TARGET_ASSIGNMENT_METADATA: {
                this.groupMetadataManager.replay((ShareGroupTargetAssignmentMetadataKey)key, (ShareGroupTargetAssignmentMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case SHARE_GROUP_TARGET_ASSIGNMENT_MEMBER: {
                this.groupMetadataManager.replay((ShareGroupTargetAssignmentMemberKey)key, (ShareGroupTargetAssignmentMemberValue)Utils.messageOrNull(value));
                break;
            }
            case SHARE_GROUP_CURRENT_MEMBER_ASSIGNMENT: {
                this.groupMetadataManager.replay((ShareGroupCurrentMemberAssignmentKey)key, (ShareGroupCurrentMemberAssignmentValue)Utils.messageOrNull(value));
                break;
            }
            case SHARE_GROUP_STATE_PARTITION_METADATA: {
                this.groupMetadataManager.replay((ShareGroupStatePartitionMetadataKey)key, (ShareGroupStatePartitionMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case CONSUMER_GROUP_REGULAR_EXPRESSION: {
                this.groupMetadataManager.replay((ConsumerGroupRegularExpressionKey)key, (ConsumerGroupRegularExpressionValue)Utils.messageOrNull(value));
                break;
            }
            case STREAMS_GROUP_METADATA: {
                this.groupMetadataManager.replay((StreamsGroupMetadataKey)key, (StreamsGroupMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case STREAMS_GROUP_MEMBER_METADATA: {
                this.groupMetadataManager.replay((StreamsGroupMemberMetadataKey)key, (StreamsGroupMemberMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case STREAMS_GROUP_TARGET_ASSIGNMENT_METADATA: {
                this.groupMetadataManager.replay((StreamsGroupTargetAssignmentMetadataKey)key, (StreamsGroupTargetAssignmentMetadataValue)Utils.messageOrNull(value));
                break;
            }
            case STREAMS_GROUP_TARGET_ASSIGNMENT_MEMBER: {
                this.groupMetadataManager.replay((StreamsGroupTargetAssignmentMemberKey)key, (StreamsGroupTargetAssignmentMemberValue)Utils.messageOrNull(value));
                break;
            }
            case STREAMS_GROUP_CURRENT_MEMBER_ASSIGNMENT: {
                this.groupMetadataManager.replay((StreamsGroupCurrentMemberAssignmentKey)key, (StreamsGroupCurrentMemberAssignmentValue)Utils.messageOrNull(value));
                break;
            }
            case STREAMS_GROUP_TOPOLOGY: {
                this.groupMetadataManager.replay((StreamsGroupTopologyKey)key, (StreamsGroupTopologyValue)Utils.messageOrNull(value));
                break;
            }
            default: {
                throw new IllegalStateException("Received an unknown record type " + String.valueOf((Object)recordType) + " in " + String.valueOf(record));
            }
        }
    }

    public void replayEndTransactionMarker(long producerId, short producerEpoch, TransactionResult result) throws RuntimeException {
        this.offsetMetadataManager.replayEndTransactionMarker(producerId, result);
    }

    public static class DeleteShareGroupOffsetsResultHolder {
        private final short topLevelErrorCode;
        private final String topLevelErrorMessage;
        private final List<DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic> errorTopicResponseList;
        private final DeleteShareGroupStateParameters deleteStateRequestParameters;

        DeleteShareGroupOffsetsResultHolder(short topLevelErrorCode, String topLevelErrorMessage) {
            this(topLevelErrorCode, topLevelErrorMessage, null, null);
        }

        DeleteShareGroupOffsetsResultHolder(short topLevelErrorCode, String topLevelErrorMessage, List<DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic> errorTopicResponseList) {
            this(topLevelErrorCode, topLevelErrorMessage, errorTopicResponseList, null);
        }

        DeleteShareGroupOffsetsResultHolder(short topLevelErrorCode, String topLevelErrorMessage, List<DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic> errorTopicResponseList, DeleteShareGroupStateParameters deleteStateRequestParameters) {
            this.topLevelErrorCode = topLevelErrorCode;
            this.topLevelErrorMessage = topLevelErrorMessage;
            this.errorTopicResponseList = errorTopicResponseList;
            this.deleteStateRequestParameters = deleteStateRequestParameters;
        }

        public short topLevelErrorCode() {
            return this.topLevelErrorCode;
        }

        public String topLevelErrorMessage() {
            return this.topLevelErrorMessage;
        }

        public List<DeleteShareGroupOffsetsResponseData.DeleteShareGroupOffsetsResponseTopic> errorTopicResponseList() {
            return this.errorTopicResponseList;
        }

        public DeleteShareGroupStateParameters deleteStateRequestParameters() {
            return this.deleteStateRequestParameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DeleteShareGroupOffsetsResultHolder other = (DeleteShareGroupOffsetsResultHolder)o;
            return this.topLevelErrorCode == other.topLevelErrorCode && Objects.equals(this.topLevelErrorMessage, other.topLevelErrorMessage) && Objects.equals(this.errorTopicResponseList, other.errorTopicResponseList) && Objects.equals(this.deleteStateRequestParameters, other.deleteStateRequestParameters);
        }

        public int hashCode() {
            return Objects.hash(this.topLevelErrorCode, this.topLevelErrorMessage, this.errorTopicResponseList, this.deleteStateRequestParameters);
        }
    }

    public static class Builder
    implements CoordinatorShardBuilder<GroupCoordinatorShard, CoordinatorRecord> {
        private final GroupCoordinatorConfig config;
        private final GroupConfigManager groupConfigManager;
        private LogContext logContext;
        private SnapshotRegistry snapshotRegistry;
        private Time time;
        private CoordinatorTimer<Void, CoordinatorRecord> timer;
        private CoordinatorExecutor<CoordinatorRecord> executor;
        private CoordinatorMetrics coordinatorMetrics;
        private TopicPartition topicPartition;
        private Optional<Plugin<Authorizer>> authorizerPlugin;

        public Builder(GroupCoordinatorConfig config, GroupConfigManager groupConfigManager) {
            this.config = config;
            this.groupConfigManager = groupConfigManager;
        }

        public CoordinatorShardBuilder<GroupCoordinatorShard, CoordinatorRecord> withLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        public CoordinatorShardBuilder<GroupCoordinatorShard, CoordinatorRecord> withTime(Time time) {
            this.time = time;
            return this;
        }

        public CoordinatorShardBuilder<GroupCoordinatorShard, CoordinatorRecord> withTimer(CoordinatorTimer<Void, CoordinatorRecord> timer) {
            this.timer = timer;
            return this;
        }

        public CoordinatorShardBuilder<GroupCoordinatorShard, CoordinatorRecord> withExecutor(CoordinatorExecutor<CoordinatorRecord> executor) {
            this.executor = executor;
            return this;
        }

        public CoordinatorShardBuilder<GroupCoordinatorShard, CoordinatorRecord> withCoordinatorMetrics(CoordinatorMetrics coordinatorMetrics) {
            this.coordinatorMetrics = coordinatorMetrics;
            return this;
        }

        public CoordinatorShardBuilder<GroupCoordinatorShard, CoordinatorRecord> withTopicPartition(TopicPartition topicPartition) {
            this.topicPartition = topicPartition;
            return this;
        }

        public CoordinatorShardBuilder<GroupCoordinatorShard, CoordinatorRecord> withSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        public CoordinatorShardBuilder<GroupCoordinatorShard, CoordinatorRecord> withAuthorizerPlugin(Optional<Plugin<Authorizer>> authorizerPlugin) {
            this.authorizerPlugin = authorizerPlugin;
            return this;
        }

        public GroupCoordinatorShard build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.config == null) {
                throw new IllegalArgumentException("Config must be set.");
            }
            if (this.snapshotRegistry == null) {
                throw new IllegalArgumentException("SnapshotRegistry must be set.");
            }
            if (this.time == null) {
                throw new IllegalArgumentException("Time must be set.");
            }
            if (this.timer == null) {
                throw new IllegalArgumentException("Timer must be set.");
            }
            if (this.executor == null) {
                throw new IllegalArgumentException("Executor must be set.");
            }
            if (this.coordinatorMetrics == null || !(this.coordinatorMetrics instanceof GroupCoordinatorMetrics)) {
                throw new IllegalArgumentException("CoordinatorMetrics must be set and be of type GroupCoordinatorMetrics.");
            }
            if (this.topicPartition == null) {
                throw new IllegalArgumentException("TopicPartition must be set.");
            }
            if (this.groupConfigManager == null) {
                throw new IllegalArgumentException("GroupConfigManager must be set.");
            }
            if (this.authorizerPlugin == null) {
                throw new IllegalArgumentException("Authorizer must be set.");
            }
            GroupCoordinatorMetricsShard metricsShard = ((GroupCoordinatorMetrics)this.coordinatorMetrics).newMetricsShard(this.snapshotRegistry, this.topicPartition);
            GroupMetadataManager groupMetadataManager = new GroupMetadataManager.Builder().withLogContext(this.logContext).withSnapshotRegistry(this.snapshotRegistry).withTime(this.time).withTimer(this.timer).withExecutor(this.executor).withConfig(this.config).withGroupConfigManager(this.groupConfigManager).withGroupCoordinatorMetricsShard(metricsShard).withShareGroupAssignor(this.config.shareGroupAssignors().get(0)).withAuthorizerPlugin(this.authorizerPlugin).build();
            OffsetMetadataManager offsetMetadataManager = new OffsetMetadataManager.Builder().withLogContext(this.logContext).withSnapshotRegistry(this.snapshotRegistry).withTime(this.time).withGroupMetadataManager(groupMetadataManager).withGroupCoordinatorConfig(this.config).withGroupCoordinatorMetricsShard(metricsShard).build();
            return new GroupCoordinatorShard(this.logContext, groupMetadataManager, offsetMetadataManager, this.time, this.timer, this.config, this.coordinatorMetrics, metricsShard);
        }
    }
}

