/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class LegacyOffsetCommitValue
implements ApiMessage {
    long offset;
    String metadata;
    long commitTimestamp;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("offset", (Type)Type.INT64, "The offset that the consumer wants to store (for this partition)."), new Field("metadata", (Type)Type.STRING, "Any metadata the client wants to keep."), new Field("commit_timestamp", (Type)Type.INT64, "The time at which the commit was added to the log.")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public LegacyOffsetCommitValue(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public LegacyOffsetCommitValue(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public LegacyOffsetCommitValue() {
        this.offset = 0L;
        this.metadata = "";
        this.commitTimestamp = 0L;
    }

    public short apiKey() {
        return 0;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        this.offset = _readable.readLong();
        short length = _readable.readShort();
        if (length < 0) {
            throw new RuntimeException("non-nullable field metadata was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field metadata had invalid length " + length);
        }
        this.metadata = _readable.readString((int)length);
        this.commitTimestamp = _readable.readLong();
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeLong(this.offset);
        byte[] _stringBytes = _cache.getSerializedValue((Object)this.metadata);
        _writable.writeShort((short)_stringBytes.length);
        _writable.writeByteArray(_stringBytes);
        _writable.writeLong(this.commitTimestamp);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(8);
        byte[] _stringBytes = this.metadata.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'metadata' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.metadata, _stringBytes);
        _size.addBytes(_stringBytes.length + 2);
        _size.addBytes(8);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LegacyOffsetCommitValue)) {
            return false;
        }
        LegacyOffsetCommitValue other = (LegacyOffsetCommitValue)obj;
        if (this.offset != other.offset) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.commitTimestamp != other.commitTimestamp) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
        hashCode = 31 * hashCode + (this.metadata == null ? 0 : this.metadata.hashCode());
        hashCode = 31 * hashCode + ((int)(this.commitTimestamp >> 32) ^ (int)this.commitTimestamp);
        return hashCode;
    }

    public LegacyOffsetCommitValue duplicate() {
        LegacyOffsetCommitValue _duplicate = new LegacyOffsetCommitValue();
        _duplicate.offset = this.offset;
        _duplicate.metadata = this.metadata;
        _duplicate.commitTimestamp = this.commitTimestamp;
        return _duplicate;
    }

    public String toString() {
        return "LegacyOffsetCommitValue(offset=" + this.offset + ", metadata=" + (String)(this.metadata == null ? "null" : "'" + this.metadata.toString() + "'") + ", commitTimestamp=" + this.commitTimestamp + ")";
    }

    public long offset() {
        return this.offset;
    }

    public String metadata() {
        return this.metadata;
    }

    public long commitTimestamp() {
        return this.commitTimestamp;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LegacyOffsetCommitValue setOffset(long v) {
        this.offset = v;
        return this;
    }

    public LegacyOffsetCommitValue setMetadata(String v) {
        this.metadata = v;
        return this;
    }

    public LegacyOffsetCommitValue setCommitTimestamp(long v) {
        this.commitTimestamp = v;
        return this;
    }
}

