/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.modern.consumer;

import io.confluent.kafka.multitenant.TenantUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.kafka.clients.consumer.internals.ConsumerProtocol;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.IllegalGenerationException;
import org.apache.kafka.common.errors.StaleMemberEpochException;
import org.apache.kafka.common.errors.UnknownMemberIdException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ConsumerGroupDescribeResponseData;
import org.apache.kafka.common.message.ConsumerProtocolAssignment;
import org.apache.kafka.common.message.ConsumerProtocolSubscription;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.OffsetExpirationCondition;
import org.apache.kafka.coordinator.group.OffsetExpirationConditionImpl;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.api.assignor.SubscriptionType;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupMember;
import org.apache.kafka.coordinator.group.generated.ConsumerGroupMemberMetadataValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.modern.Assignment;
import org.apache.kafka.coordinator.group.modern.MemberState;
import org.apache.kafka.coordinator.group.modern.ModernGroup;
import org.apache.kafka.coordinator.group.modern.ModernGroupMember;
import org.apache.kafka.coordinator.group.modern.SubscriptionCount;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroupMember;
import org.apache.kafka.coordinator.group.modern.consumer.ResolvedRegularExpression;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.TopicsImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineInteger;
import org.apache.kafka.timeline.TimelineObject;

public class ConsumerGroup
extends ModernGroup<ConsumerGroupMember> {
    private final Time time;
    private final TimelineObject<ConsumerGroupState> state;
    private final TimelineHashMap<String, String> staticMembers;
    private final TimelineHashMap<String, Integer> serverAssignors;
    private final GroupCoordinatorMetricsShard metrics;
    private final TimelineInteger numClassicProtocolMembers;
    private final TimelineHashMap<String, Integer> classicProtocolMembersSupportedProtocols;
    private final TimelineObject<Optional<Long>> rebalanceStartTimestampMs;
    private final TimelineHashMap<Uuid, TimelineHashMap<Integer, Integer>> currentPartitionEpoch;
    private final TimelineHashMap<String, Integer> subscribedRegularExpressions;
    private final TimelineHashMap<String, ResolvedRegularExpression> resolvedRegularExpressions;
    private final TimelineObject<Boolean> hasSubscriptionMetadataRecord;

    public ConsumerGroup(Time time, SnapshotRegistry snapshotRegistry, String groupId, GroupCoordinatorMetricsShard metrics) {
        super(snapshotRegistry, groupId);
        this.time = time;
        this.state = new TimelineObject(snapshotRegistry, (Object)ConsumerGroupState.EMPTY);
        this.staticMembers = new TimelineHashMap(snapshotRegistry, 0);
        this.serverAssignors = new TimelineHashMap(snapshotRegistry, 0);
        this.metrics = Objects.requireNonNull(metrics);
        this.numClassicProtocolMembers = new TimelineInteger(snapshotRegistry);
        this.classicProtocolMembersSupportedProtocols = new TimelineHashMap(snapshotRegistry, 0);
        this.rebalanceStartTimestampMs = new TimelineObject(snapshotRegistry, Optional.empty());
        this.currentPartitionEpoch = new TimelineHashMap(snapshotRegistry, 0);
        this.subscribedRegularExpressions = new TimelineHashMap(snapshotRegistry, 0);
        this.resolvedRegularExpressions = new TimelineHashMap(snapshotRegistry, 0);
        this.hasSubscriptionMetadataRecord = new TimelineObject(snapshotRegistry, (Object)false);
    }

    @Override
    public Group.GroupType type() {
        return Group.GroupType.CONSUMER;
    }

    @Override
    public String protocolType() {
        return "consumer";
    }

    @Override
    public String stateAsString() {
        return ((ConsumerGroupState)((Object)this.state.get())).toString();
    }

    @Override
    public String stateAsString(long committedOffset) {
        return ((ConsumerGroupState)((Object)this.state.get(committedOffset))).toString();
    }

    public ConsumerGroupState state() {
        return (ConsumerGroupState)((Object)this.state.get());
    }

    public ConsumerGroupState state(long committedOffset) {
        return (ConsumerGroupState)((Object)this.state.get(committedOffset));
    }

    public Optional<Long> rebalanceStartTimestampMs() {
        return (Optional)this.rebalanceStartTimestampMs.get();
    }

    void setRebalanceStartTimestampMs(Optional<Long> rebalanceStartTimestampMs) {
        this.rebalanceStartTimestampMs.set(rebalanceStartTimestampMs);
    }

    public void setNumClassicProtocolMembers(int numClassicProtocolMembers) {
        this.numClassicProtocolMembers.set(numClassicProtocolMembers);
    }

    public String staticMemberId(String groupInstanceId) {
        if (groupInstanceId == null) {
            return null;
        }
        return (String)this.staticMembers.get((Object)groupInstanceId);
    }

    @Override
    public ConsumerGroupMember getOrMaybeCreateMember(String memberId, boolean createIfNotExists) throws UnknownMemberIdException {
        ConsumerGroupMember member = (ConsumerGroupMember)this.members.get((Object)memberId);
        if (member != null) {
            return member;
        }
        if (!createIfNotExists) {
            throw new UnknownMemberIdException(String.format("Member %s is not a member of group %s.", memberId, this.groupId));
        }
        return new ConsumerGroupMember.Builder(memberId).build();
    }

    public ConsumerGroupMember staticMember(String instanceId) {
        String existingMemberId = this.staticMemberId(instanceId);
        return existingMemberId == null ? null : this.getOrMaybeCreateMember(existingMemberId, false);
    }

    public boolean hasStaticMember(String instanceId) {
        if (instanceId == null) {
            return false;
        }
        return this.staticMembers.containsKey((Object)instanceId);
    }

    public Assignment targetAssignment(String memberId, String instanceId) {
        if (instanceId == null) {
            return this.targetAssignment(memberId);
        }
        String previousMemberId = this.staticMemberId(instanceId);
        if (previousMemberId != null) {
            return this.targetAssignment(previousMemberId);
        }
        return Assignment.EMPTY;
    }

    @Override
    public void updateMember(ConsumerGroupMember newMember) {
        if (newMember == null) {
            throw new IllegalArgumentException("newMember cannot be null.");
        }
        ConsumerGroupMember oldMember = (ConsumerGroupMember)this.members.put((Object)newMember.memberId(), (Object)newMember);
        this.maybeUpdateSubscribedTopicNames(oldMember, newMember);
        this.maybeUpdateServerAssignors(oldMember, newMember);
        this.maybeUpdatePartitionEpoch(oldMember, newMember);
        this.maybeUpdateSubscribedRegularExpression(oldMember, newMember);
        this.updateStaticMember(newMember);
        this.maybeUpdateGroupState();
        this.maybeUpdateGroupSubscriptionType();
        this.maybeUpdateNumClassicProtocolMembers(oldMember, newMember);
        this.maybeUpdateClassicProtocolMembersSupportedProtocols(oldMember, newMember);
    }

    private void updateStaticMember(ConsumerGroupMember newMember) {
        if (newMember.instanceId() != null) {
            this.staticMembers.put((Object)newMember.instanceId(), (Object)newMember.memberId());
        }
    }

    @Override
    public void removeMember(String memberId) {
        ConsumerGroupMember oldMember = (ConsumerGroupMember)this.members.remove((Object)memberId);
        this.maybeUpdateSubscribedTopicNames(oldMember, null);
        this.maybeUpdateServerAssignors(oldMember, null);
        this.maybeRemovePartitionEpoch(oldMember);
        this.maybeUpdateSubscribedRegularExpression(oldMember, null);
        this.removeStaticMember(oldMember);
        this.maybeUpdateGroupState();
        this.maybeUpdateGroupSubscriptionType();
        this.maybeUpdateNumClassicProtocolMembers(oldMember, null);
        this.maybeUpdateClassicProtocolMembersSupportedProtocols(oldMember, null);
    }

    private void removeStaticMember(ConsumerGroupMember oldMember) {
        if (oldMember != null && oldMember.instanceId() != null) {
            this.staticMembers.remove((Object)oldMember.instanceId());
        }
    }

    public Map<String, SubscriptionCount> computeSubscribedTopicNames(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        String newSubscribedTopicRegex;
        Map<String, SubscriptionCount> subscribedTopicsNames = super.computeSubscribedTopicNames(oldMember, newMember);
        String oldSubscribedTopicRegex = ConsumerGroupMember.subscribedTopicRegexOrNull(oldMember);
        if (oldSubscribedTopicRegex != null && !oldSubscribedTopicRegex.equals(newSubscribedTopicRegex = ConsumerGroupMember.subscribedTopicRegexOrNull(newMember)) && this.numSubscribedMembers(oldSubscribedTopicRegex) == 1) {
            this.resolvedRegularExpression(oldSubscribedTopicRegex).ifPresent(resolvedRegularExpression -> resolvedRegularExpression.topics.forEach(topic -> subscribedTopicsNames.compute((String)topic, SubscriptionCount::decRegexCount)));
        }
        return subscribedTopicsNames;
    }

    public Map<String, Integer> computeSubscribedRegularExpressions(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        String newRegex;
        String oldRegex = ConsumerGroupMember.subscribedTopicRegexOrNull(oldMember);
        if (!Objects.equals(oldRegex, newRegex = ConsumerGroupMember.subscribedTopicRegexOrNull(newMember))) {
            HashMap<String, Integer> newSubscribedRegularExpressions = new HashMap<String, Integer>((Map<String, Integer>)this.subscribedRegularExpressions);
            if (oldRegex != null) {
                newSubscribedRegularExpressions.compute(oldRegex, Utils::decValue);
            }
            if (newRegex != null) {
                newSubscribedRegularExpressions.compute(newRegex, Utils::incValue);
            }
            return Collections.unmodifiableMap(newSubscribedRegularExpressions);
        }
        return Collections.unmodifiableMap(this.subscribedRegularExpressions);
    }

    public Map<String, SubscriptionCount> computeSubscribedTopicNamesWithoutDeletedMembers(Set<ConsumerGroupMember> removedMembers, Set<String> removedRegexes) {
        Map<String, SubscriptionCount> subscribedTopicsNames = super.computeSubscribedTopicNames(removedMembers);
        removedRegexes.forEach(regex -> this.resolvedRegularExpression((String)regex).ifPresent(resolvedRegularExpression -> resolvedRegularExpression.topics.forEach(topic -> subscribedTopicsNames.compute((String)topic, SubscriptionCount::decRegexCount))));
        return subscribedTopicsNames;
    }

    public void updateResolvedRegularExpression(String regex, ResolvedRegularExpression newResolvedRegularExpression) {
        this.removeResolvedRegularExpression(regex);
        if (newResolvedRegularExpression != null) {
            this.resolvedRegularExpressions.put((Object)regex, (Object)newResolvedRegularExpression);
            newResolvedRegularExpression.topics.forEach(topicName -> this.subscribedTopicNames.compute(topicName, SubscriptionCount::incRegexCount));
        }
    }

    public void removeResolvedRegularExpression(String regex) {
        ResolvedRegularExpression oldResolvedRegularExpression = (ResolvedRegularExpression)this.resolvedRegularExpressions.remove((Object)regex);
        if (oldResolvedRegularExpression != null) {
            oldResolvedRegularExpression.topics.forEach(topicName -> this.subscribedTopicNames.compute(topicName, SubscriptionCount::decRegexCount));
        }
    }

    public long lastResolvedRegularExpressionRefreshTimeMs() {
        Iterator iterator = this.resolvedRegularExpressions.values().iterator();
        if (iterator.hasNext()) {
            return ((ResolvedRegularExpression)iterator.next()).timestamp;
        }
        return Long.MIN_VALUE;
    }

    public long lastResolvedRegularExpressionVersion() {
        Iterator iterator = this.resolvedRegularExpressions.values().iterator();
        if (iterator.hasNext()) {
            return ((ResolvedRegularExpression)iterator.next()).version;
        }
        return 0L;
    }

    public Optional<ResolvedRegularExpression> resolvedRegularExpression(String regex) {
        return Optional.ofNullable((ResolvedRegularExpression)this.resolvedRegularExpressions.get((Object)regex));
    }

    public int numResolvedRegularExpressions() {
        return this.resolvedRegularExpressions.size();
    }

    public int numSubscribedMembers(String regex) {
        return (Integer)this.subscribedRegularExpressions.getOrDefault((Object)regex, (Object)0);
    }

    public Map<String, Integer> subscribedRegularExpressions() {
        return Collections.unmodifiableMap(this.subscribedRegularExpressions);
    }

    public int numClassicProtocolMembers() {
        return this.numClassicProtocolMembers.get();
    }

    public Map<String, Integer> classicMembersSupportedProtocols() {
        return Collections.unmodifiableMap(this.classicProtocolMembersSupportedProtocols);
    }

    public Map<String, String> staticMembers() {
        return Collections.unmodifiableMap(this.staticMembers);
    }

    public Map<String, ResolvedRegularExpression> resolvedRegularExpressions() {
        return Collections.unmodifiableMap(this.resolvedRegularExpressions);
    }

    public int currentPartitionEpoch(Uuid topicId, int partitionId) {
        Map partitions = (Map)this.currentPartitionEpoch.get((Object)topicId);
        if (partitions == null) {
            return -1;
        }
        return partitions.getOrDefault(partitionId, -1);
    }

    public Optional<String> computePreferredServerAssignor(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>((Map<String, Integer>)this.serverAssignors);
        ConsumerGroup.maybeUpdateServerAssignors(counts, oldMember, newMember);
        return counts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    public Optional<String> preferredServerAssignor() {
        return this.preferredServerAssignor(Long.MAX_VALUE);
    }

    public Optional<String> preferredServerAssignor(long committedOffset) {
        return this.serverAssignors.entrySet(committedOffset).stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey);
    }

    @Override
    public void validateOffsetCommit(String memberId, String groupInstanceId, int memberEpoch, boolean isTransactional, int apiVersion) throws UnknownMemberIdException, StaleMemberEpochException, IllegalGenerationException {
        if (memberEpoch < 0 && this.members().isEmpty()) {
            return;
        }
        if (isTransactional && memberEpoch == -1 && memberId.equals("") && groupInstanceId == null) {
            return;
        }
        ConsumerGroupMember member = this.getOrMaybeCreateMember(memberId, false);
        if (!isTransactional && !member.useClassicProtocol() && apiVersion < 9) {
            throw new UnsupportedVersionException("OffsetCommit version 9 or above must be used by members using the modern group protocol");
        }
        this.validateMemberEpoch(memberEpoch, member.memberEpoch(), member.useClassicProtocol());
    }

    @Override
    public void validateOffsetFetch(String memberId, int memberEpoch, long lastCommittedOffset) throws UnknownMemberIdException, StaleMemberEpochException, IllegalGenerationException {
        if (memberId == null && memberEpoch < 0) {
            return;
        }
        ConsumerGroupMember member = (ConsumerGroupMember)this.members.get((Object)memberId, lastCommittedOffset);
        if (member == null) {
            throw new UnknownMemberIdException(String.format("Member %s is not a member of group %s.", memberId, this.groupId));
        }
        this.validateMemberEpoch(memberEpoch, member.memberEpoch(), member.useClassicProtocol());
    }

    @Override
    public void validateOffsetDelete() {
    }

    @Override
    public void validateDeleteGroup() throws ApiException {
        if (this.state() != ConsumerGroupState.EMPTY) {
            throw Errors.NON_EMPTY_GROUP.exception();
        }
    }

    @Override
    public void createGroupTombstoneRecords(List<CoordinatorRecord> records) {
        this.members.keySet().forEach(memberId -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord(this.groupId, memberId)));
        this.members.keySet().forEach(memberId -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord(this.groupId, memberId)));
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord(this.groupId));
        this.members.keySet().forEach(memberId -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord(this.groupId, memberId)));
        this.resolvedRegularExpressions.keySet().forEach(regex -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone(this.groupId, regex)));
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord(this.groupId));
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord(this.groupId));
    }

    public void createGroupTombstoneRecordsWithReplacedMember(List<CoordinatorRecord> records, String leavingMemberId, String joiningMemberId) {
        this.members.keySet().forEach(memberId -> {
            String removedMemberId = memberId.equals(leavingMemberId) ? joiningMemberId : memberId;
            records.add(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentTombstoneRecord(this.groupId, removedMemberId));
        });
        this.members.keySet().forEach(memberId -> {
            String removedMemberId = memberId.equals(leavingMemberId) ? joiningMemberId : memberId;
            records.add(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentTombstoneRecord(this.groupId, removedMemberId));
        });
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochTombstoneRecord(this.groupId));
        this.members.keySet().forEach(memberId -> {
            String removedMemberId = memberId.equals(leavingMemberId) ? joiningMemberId : memberId;
            records.add(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionTombstoneRecord(this.groupId, removedMemberId));
        });
        this.resolvedRegularExpressions.keySet().forEach(regex -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupRegularExpressionTombstone(this.groupId, regex)));
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupSubscriptionMetadataTombstoneRecord(this.groupId));
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupEpochTombstoneRecord(this.groupId));
    }

    @Override
    public boolean isEmpty() {
        return this.state() == ConsumerGroupState.EMPTY;
    }

    @Override
    public Optional<OffsetExpirationCondition> offsetExpirationCondition() {
        return Optional.of(new OffsetExpirationConditionImpl(offsetAndMetadata -> offsetAndMetadata.commitTimestampMs));
    }

    @Override
    public boolean isInStates(Set<String> statesFilter, long committedOffset) {
        return statesFilter.contains(((ConsumerGroupState)((Object)this.state.get(committedOffset))).toLowerCaseString());
    }

    private void validateMemberEpoch(int receivedMemberEpoch, int expectedMemberEpoch, boolean useClassicProtocol) throws StaleMemberEpochException, IllegalGenerationException {
        if (receivedMemberEpoch != expectedMemberEpoch) {
            if (useClassicProtocol) {
                throw new IllegalGenerationException(String.format("The received generation id %d does not match the expected member epoch %d.", receivedMemberEpoch, expectedMemberEpoch));
            }
            throw new StaleMemberEpochException(String.format("The received member epoch %d does not match the expected member epoch %d.", receivedMemberEpoch, expectedMemberEpoch));
        }
    }

    public static SubscriptionType subscriptionType(Map<String, Integer> subscribedRegularExpressions, Map<String, SubscriptionCount> subscribedTopicNames, int numberOfMembers) {
        if (subscribedRegularExpressions.isEmpty()) {
            for (SubscriptionCount subscriberCount : subscribedTopicNames.values()) {
                if (subscriberCount.byNameCount == numberOfMembers) continue;
                return SubscriptionType.HETEROGENEOUS;
            }
            return SubscriptionType.HOMOGENEOUS;
        }
        int count = subscribedRegularExpressions.values().iterator().next();
        if (count == numberOfMembers) {
            for (SubscriptionCount subscriberCount : subscribedTopicNames.values()) {
                if (subscriberCount.byRegexCount == 1 && subscriberCount.byNameCount <= 0) continue;
                return SubscriptionType.HETEROGENEOUS;
            }
            return SubscriptionType.HOMOGENEOUS;
        }
        return SubscriptionType.HETEROGENEOUS;
    }

    @Override
    protected void maybeUpdateGroupSubscriptionType() {
        this.subscriptionType.set((Object)ConsumerGroup.subscriptionType(this.subscribedRegularExpressions, (Map<String, SubscriptionCount>)this.subscribedTopicNames, this.members.size()));
    }

    @Override
    protected void maybeUpdateGroupState() {
        ConsumerGroupState previousState = (ConsumerGroupState)((Object)this.state.get());
        ConsumerGroupState newState = ConsumerGroupState.STABLE;
        if (this.members.isEmpty()) {
            newState = ConsumerGroupState.EMPTY;
        } else if (this.groupEpoch.get() > this.targetAssignmentEpoch.get()) {
            newState = ConsumerGroupState.ASSIGNING;
        } else {
            for (ModernGroupMember member : this.members.values()) {
                if (member.isReconciledTo(this.targetAssignmentEpoch.get())) continue;
                newState = ConsumerGroupState.RECONCILING;
                break;
            }
        }
        this.state.set((Object)newState);
        this.rebalanceStartTimestampMs.set(this.getRebalanceStartTimestampMs(previousState, newState));
    }

    private void maybeUpdateServerAssignors(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        ConsumerGroup.maybeUpdateServerAssignors(this.serverAssignors, oldMember, newMember);
    }

    private static void maybeUpdateServerAssignors(Map<String, Integer> serverAssignorCount, ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null) {
            oldMember.serverAssignorName().ifPresent(name -> serverAssignorCount.compute((String)name, Utils::decValue));
        }
        if (newMember != null) {
            newMember.serverAssignorName().ifPresent(name -> serverAssignorCount.compute((String)name, Utils::incValue));
        }
    }

    private void maybeUpdateSubscribedRegularExpression(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null && oldMember.subscribedTopicRegex() != null && !oldMember.subscribedTopicRegex().isEmpty()) {
            this.subscribedRegularExpressions.compute((Object)oldMember.subscribedTopicRegex(), Utils::decValue);
        }
        if (newMember != null && newMember.subscribedTopicRegex() != null && !newMember.subscribedTopicRegex().isEmpty()) {
            this.subscribedRegularExpressions.compute((Object)newMember.subscribedTopicRegex(), Utils::incValue);
        }
    }

    private void maybeUpdateNumClassicProtocolMembers(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        int delta = 0;
        if (oldMember != null && oldMember.useClassicProtocol()) {
            --delta;
        }
        if (newMember != null && newMember.useClassicProtocol()) {
            ++delta;
        }
        this.setNumClassicProtocolMembers(this.numClassicProtocolMembers() + delta);
    }

    private void maybeUpdateClassicProtocolMembersSupportedProtocols(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        if (oldMember != null) {
            oldMember.supportedClassicProtocols().ifPresent(protocols -> protocols.forEach(protocol -> this.classicProtocolMembersSupportedProtocols.compute((Object)protocol.name(), Utils::decValue)));
        }
        if (newMember != null) {
            newMember.supportedClassicProtocols().ifPresent(protocols -> protocols.forEach(protocol -> this.classicProtocolMembersSupportedProtocols.compute((Object)protocol.name(), Utils::incValue)));
        }
    }

    private void maybeUpdatePartitionEpoch(ConsumerGroupMember oldMember, ConsumerGroupMember newMember) {
        this.maybeRemovePartitionEpoch(oldMember);
        this.addPartitionEpochs(newMember.assignedPartitions(), newMember.memberEpoch());
        this.addPartitionEpochs(newMember.partitionsPendingRevocation(), newMember.memberEpoch());
    }

    private void maybeRemovePartitionEpoch(ConsumerGroupMember oldMember) {
        if (oldMember != null) {
            this.removePartitionEpochs(oldMember.assignedPartitions(), oldMember.memberEpoch());
            this.removePartitionEpochs(oldMember.partitionsPendingRevocation(), oldMember.memberEpoch());
        }
    }

    private Optional<Long> getRebalanceStartTimestampMs(ConsumerGroupState prevState, ConsumerGroupState nextState) {
        switch (nextState.ordinal()) {
            case 1: 
            case 2: {
                if (prevState == ConsumerGroupState.ASSIGNING || prevState == ConsumerGroupState.RECONCILING) {
                    return (Optional)this.rebalanceStartTimestampMs.get();
                }
                return Optional.of(this.time.milliseconds());
            }
        }
        return Optional.empty();
    }

    void removePartitionEpochs(Map<Uuid, Set<Integer>> assignment, int expectedEpoch) {
        assignment.forEach((topicId, assignedPartitions) -> this.currentPartitionEpoch.compute(topicId, (__, partitionsOrNull) -> {
            if (partitionsOrNull != null) {
                assignedPartitions.forEach(partitionId -> {
                    Integer prevValue = (Integer)partitionsOrNull.remove(partitionId);
                    if (prevValue != expectedEpoch) {
                        throw new IllegalStateException(String.format("Cannot remove the epoch %d from %s-%s because the partition is still owned at a different epoch %d", expectedEpoch, topicId, partitionId, prevValue));
                    }
                });
                if (partitionsOrNull.isEmpty()) {
                    return null;
                }
                return partitionsOrNull;
            }
            throw new IllegalStateException(String.format("Cannot remove the epoch %d from %s because it does not have any epoch", expectedEpoch, topicId));
        }));
    }

    void addPartitionEpochs(Map<Uuid, Set<Integer>> assignment, int epoch) {
        assignment.forEach((topicId, assignedPartitions) -> this.currentPartitionEpoch.compute(topicId, (__, partitionsOrNull) -> {
            if (partitionsOrNull == null) {
                partitionsOrNull = new TimelineHashMap(this.snapshotRegistry, assignedPartitions.size());
            }
            for (Integer partitionId : assignedPartitions) {
                Integer prevValue = (Integer)partitionsOrNull.put((Object)partitionId, (Object)epoch);
                if (prevValue == null) continue;
                throw new IllegalStateException(String.format("Cannot set the epoch of %s-%s to %d because the partition is still owned at epoch %d", topicId, partitionId, epoch, prevValue));
            }
            return partitionsOrNull;
        }));
    }

    public ConsumerGroupDescribeResponseData.DescribedGroup asDescribedGroup(long committedOffset, String defaultAssignor, TopicsImage topicsImage) {
        ConsumerGroupDescribeResponseData.DescribedGroup describedGroup = new ConsumerGroupDescribeResponseData.DescribedGroup().setGroupId(this.groupId).setAssignorName(this.preferredServerAssignor(committedOffset).orElse(defaultAssignor)).setGroupEpoch(this.groupEpoch.get(committedOffset)).setGroupState(((ConsumerGroupState)((Object)this.state.get(committedOffset))).toString()).setAssignmentEpoch(this.targetAssignmentEpoch.get(committedOffset));
        this.members.entrySet(committedOffset).forEach(entry -> describedGroup.members().add(((ConsumerGroupMember)entry.getValue()).asConsumerGroupDescribeMember((Assignment)this.targetAssignment.get((Object)((ConsumerGroupMember)entry.getValue()).memberId(), committedOffset), topicsImage)));
        return describedGroup;
    }

    public static ConsumerGroup fromClassicGroup(SnapshotRegistry snapshotRegistry, GroupCoordinatorMetricsShard metrics, ClassicGroup classicGroup, Map<String, Long> topicHashCache, MetadataImage metadataImage, Time time) {
        String groupId = classicGroup.groupId();
        ConsumerGroup consumerGroup = new ConsumerGroup(time, snapshotRegistry, groupId, metrics);
        consumerGroup.setGroupEpoch(classicGroup.generationId());
        consumerGroup.setTargetAssignmentEpoch(classicGroup.generationId());
        Function tenantPrefixer = TenantUtils.tenantPrefixer((String)groupId);
        classicGroup.allMembers().forEach(classicGroupMember -> {
            Map<Uuid, Set<Integer>> assignedPartitions;
            if (Arrays.equals(classicGroupMember.assignment(), ClassicGroupMember.EMPTY_ASSIGNMENT)) {
                assignedPartitions = Map.of();
            } else {
                ConsumerProtocolAssignment assignment = ConsumerProtocol.deserializeConsumerProtocolAssignment((ByteBuffer)ByteBuffer.wrap(classicGroupMember.assignment()));
                if (assignment.userData() != null && assignment.userData().hasRemaining()) {
                    throw new UnsupportedVersionException("userData from a custom assignor would be lost");
                }
                assignedPartitions = Utils.toTopicPartitionMap(assignment, metadataImage.topics(), tenantPrefixer);
            }
            ConsumerProtocolSubscription subscription = ConsumerProtocol.deserializeConsumerProtocolSubscription((ByteBuffer)ByteBuffer.wrap(classicGroupMember.metadata(classicGroup.protocolName().get())));
            ConsumerGroupMember newMember = new ConsumerGroupMember.Builder(classicGroupMember.memberId()).setMemberEpoch(classicGroup.generationId()).setState(MemberState.STABLE).setPreviousMemberEpoch(classicGroup.generationId()).setInstanceId(classicGroupMember.groupInstanceId().orElse(null)).setRackId(Utils.toOptional(subscription.rackId()).orElse(null)).setRebalanceTimeoutMs(classicGroupMember.rebalanceTimeoutMs()).setClientId(classicGroupMember.clientId()).setClientHost(classicGroupMember.clientHost()).setSubscribedTopicNames(subscription.topics()).setAssignedPartitions(assignedPartitions).setClassicMemberMetadata(new ConsumerGroupMemberMetadataValue.ClassicMemberMetadata().setSessionTimeoutMs(classicGroupMember.sessionTimeoutMs()).setSupportedProtocols(ConsumerGroupMember.classicProtocolListFromJoinRequestProtocolCollection(classicGroupMember.supportedProtocols()))).build();
            consumerGroup.updateTargetAssignment(newMember.memberId(), new Assignment(assignedPartitions));
            consumerGroup.updateMember(newMember);
        });
        consumerGroup.setMetadataHash(ModernGroup.computeMetadataHash(consumerGroup.subscribedTopicNames(), topicHashCache, metadataImage));
        return consumerGroup;
    }

    public void createConsumerGroupRecords(List<CoordinatorRecord> records) {
        this.members().forEach((__, consumerGroupMember) -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupMemberSubscriptionRecord(this.groupId(), consumerGroupMember)));
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupEpochRecord(this.groupId(), this.groupEpoch(), this.metadataHash()));
        this.members().forEach((consumerGroupMemberId, consumerGroupMember) -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentRecord(this.groupId(), consumerGroupMemberId, this.targetAssignment((String)consumerGroupMemberId).partitions())));
        records.add(GroupCoordinatorRecordHelpers.newConsumerGroupTargetAssignmentEpochRecord(this.groupId(), this.groupEpoch()));
        this.members().forEach((__, consumerGroupMember) -> records.add(GroupCoordinatorRecordHelpers.newConsumerGroupCurrentAssignmentRecord(this.groupId(), consumerGroupMember)));
    }

    public boolean supportsClassicProtocols(String memberProtocolType, Set<String> memberProtocols) {
        if ("consumer".equals(memberProtocolType)) {
            if (this.isEmpty()) {
                return !memberProtocols.isEmpty();
            }
            return memberProtocols.stream().anyMatch(name -> ((Integer)this.classicProtocolMembersSupportedProtocols.getOrDefault(name, (Object)0)).intValue() == this.numClassicProtocolMembers());
        }
        return false;
    }

    public boolean allMembersUseClassicProtocolExcept(ConsumerGroupMember member) {
        return this.numClassicProtocolMembers() == this.members().size() - 1 && !member.useClassicProtocol();
    }

    public boolean allMembersUseClassicProtocolExcept(Set<ConsumerGroupMember> members) {
        int numExcludedClassicProtocolMembers = 0;
        for (ConsumerGroupMember member : members) {
            if (!member.useClassicProtocol()) continue;
            ++numExcludedClassicProtocolMembers;
        }
        return this.numClassicProtocolMembers() - numExcludedClassicProtocolMembers == this.members().size() - members.size();
    }

    public boolean waitingOnUnreleasedPartition(ConsumerGroupMember member) {
        if (member.state() == MemberState.UNRELEASED_PARTITIONS) {
            for (Map.Entry<Uuid, Set<Integer>> entry : this.targetAssignment().get(member.memberId()).partitions().entrySet()) {
                Uuid topicId = entry.getKey();
                Set assignedPartitions = member.assignedPartitions().getOrDefault(topicId, Set.of());
                for (int partition : entry.getValue()) {
                    if (assignedPartitions.contains(partition) || this.currentPartitionEpoch(topicId, partition) == -1) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void setHasSubscriptionMetadataRecord(boolean hasSubscriptionMetadataRecord) {
        this.hasSubscriptionMetadataRecord.set((Object)hasSubscriptionMetadataRecord);
    }

    public boolean hasSubscriptionMetadataRecord() {
        return (Boolean)this.hasSubscriptionMetadataRecord.get();
    }

    public static enum ConsumerGroupState {
        EMPTY("Empty"),
        ASSIGNING("Assigning"),
        RECONCILING("Reconciling"),
        STABLE("Stable"),
        DEAD("Dead");

        private final String name;
        private final String lowerCaseName;

        private ConsumerGroupState(String name) {
            this.name = name;
            this.lowerCaseName = name.toLowerCase(Locale.ROOT);
        }

        public String toString() {
            return this.name;
        }

        public String toLowerCaseString() {
            return this.lowerCaseName;
        }
    }
}

