/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.streams;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.SortedMap;
import org.apache.kafka.coordinator.group.streams.assignor.TopologyDescriber;
import org.apache.kafka.coordinator.group.streams.topics.ConfiguredSubtopology;
import org.apache.kafka.image.MetadataImage;

public record TopologyMetadata(MetadataImage metadataImage, SortedMap<String, ConfiguredSubtopology> subtopologyMap) implements TopologyDescriber
{
    public TopologyMetadata {
        Objects.requireNonNull(metadataImage);
        subtopologyMap = Objects.requireNonNull(Collections.unmodifiableSortedMap(subtopologyMap));
    }

    @Override
    public boolean isStateful(String subtopologyId) {
        ConfiguredSubtopology subtopology = this.getSubtopologyOrFail(subtopologyId);
        return !subtopology.stateChangelogTopics().isEmpty();
    }

    @Override
    public List<String> subtopologies() {
        return this.subtopologyMap.keySet().stream().toList();
    }

    @Override
    public int maxNumInputPartitions(String subtopologyId) {
        ConfiguredSubtopology subtopology = this.getSubtopologyOrFail(subtopologyId);
        return subtopology.numberOfTasks();
    }

    private ConfiguredSubtopology getSubtopologyOrFail(String subtopologyId) {
        if (!this.subtopologyMap.containsKey(subtopologyId)) {
            throw new NoSuchElementException(String.format("Topology does not contain subtopology %s", subtopologyId));
        }
        return (ConfiguredSubtopology)this.subtopologyMap.get(subtopologyId);
    }
}

