/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.streams.WriteStream;
import java.util.function.Function;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public class BufferMapWriteStream<T>
implements WriteStream<Buffer> {
    private final Function<Buffer, T> mapper;
    private final WriteStream<T> delegate;

    public BufferMapWriteStream(Function<Buffer, T> mapper, WriteStream<T> delegate) {
        this.mapper = mapper;
        this.delegate = delegate;
    }

    public WriteStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Future<Void> write(Buffer data) {
        return this.delegate.write(this.mapper.apply(data));
    }

    public void write(Buffer data, Handler<AsyncResult<Void>> handler) {
        this.delegate.write(this.mapper.apply(data), handler);
    }

    public Future<Void> end() {
        return this.delegate.end();
    }

    public void end(Handler<AsyncResult<Void>> handler) {
        this.delegate.end(handler);
    }

    public WriteStream<Buffer> setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    public boolean writeQueueFull() {
        return this.delegate.writeQueueFull();
    }

    public WriteStream<Buffer> drainHandler(@Nullable Handler<Void> handler) {
        this.delegate.drainHandler(handler);
        return this;
    }
}

