/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.rest.client;

import com.google.common.base.Functions;
import io.confluent.ksql.properties.LocalProperties;
import io.confluent.ksql.rest.client.BufferCopyStream;
import io.confluent.ksql.rest.client.BufferMapWriteStream;
import io.confluent.ksql.rest.client.KsqlClientUtil;
import io.confluent.ksql.rest.client.KsqlTargetUtil;
import io.confluent.ksql.rest.client.ResponseWithBody;
import io.confluent.ksql.rest.client.RestResponse;
import io.confluent.ksql.rest.client.StreamPublisher;
import io.confluent.ksql.rest.client.exception.KsqlRestClientException;
import io.confluent.ksql.rest.entity.ClusterStatusResponse;
import io.confluent.ksql.rest.entity.CommandStatus;
import io.confluent.ksql.rest.entity.CommandStatuses;
import io.confluent.ksql.rest.entity.HealthCheckResponse;
import io.confluent.ksql.rest.entity.HeartbeatMessage;
import io.confluent.ksql.rest.entity.HeartbeatResponse;
import io.confluent.ksql.rest.entity.KsqlEntityList;
import io.confluent.ksql.rest.entity.KsqlHostInfoEntity;
import io.confluent.ksql.rest.entity.KsqlMediaType;
import io.confluent.ksql.rest.entity.KsqlRequest;
import io.confluent.ksql.rest.entity.LagReportingMessage;
import io.confluent.ksql.rest.entity.LagReportingResponse;
import io.confluent.ksql.rest.entity.QueryStreamArgs;
import io.confluent.ksql.rest.entity.ServerClusterId;
import io.confluent.ksql.rest.entity.ServerInfo;
import io.confluent.ksql.rest.entity.ServerMetadata;
import io.confluent.ksql.rest.entity.StreamedRow;
import io.confluent.ksql.util.VertxCompletableFuture;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.parsetools.RecordParser;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.WriteStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class KsqlTarget {
    private static final Logger log = LogManager.getLogger(KsqlTarget.class);
    private static final String STATUS_PATH = "/status";
    private static final String KSQL_PATH = "/ksql";
    private static final String QUERY_PATH = "/query";
    private static final String QUERY_STREAM_PATH = "/query-stream";
    private static final String HEARTBEAT_PATH = "/heartbeat";
    private static final String CLUSTERSTATUS_PATH = "/clusterStatus";
    private static final String LAG_REPORT_PATH = "/lag";
    private static final String SERVER_METADATA_PATH = "/v1/metadata";
    private static final String SERVER_METADATA_ID_PATH = "/v1/metadata/id";
    private static final String IS_VALID_PATH = "/is_valid_property/";
    private final HttpClient httpClient;
    private final SocketAddress socketAddress;
    private final LocalProperties localProperties;
    private final Optional<String> authHeader;
    private final String host;
    private final String subPath;
    private final Map<String, String> additionalHeaders;
    private final long timeout;

    KsqlTarget(HttpClient httpClient, SocketAddress socketAddress, LocalProperties localProperties, Optional<String> authHeader, String host, String subPath, Map<String, String> additionalHeaders, long timeout) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient");
        this.socketAddress = Objects.requireNonNull(socketAddress, "socketAddress");
        this.localProperties = Objects.requireNonNull(localProperties, "localProperties");
        this.authHeader = Objects.requireNonNull(authHeader, "authHeader");
        this.host = host;
        this.subPath = subPath.replaceAll("/\\z", "");
        this.additionalHeaders = Objects.requireNonNull(additionalHeaders, "additionalHeaders");
        this.timeout = timeout;
    }

    public KsqlTarget authorizationHeader(String authHeader) {
        return new KsqlTarget(this.httpClient, this.socketAddress, this.localProperties, Optional.of(authHeader), this.host, this.subPath, this.additionalHeaders, this.timeout);
    }

    public KsqlTarget properties(Map<String, ?> properties) {
        return new KsqlTarget(this.httpClient, this.socketAddress, new LocalProperties(properties), this.authHeader, this.host, this.subPath, this.additionalHeaders, this.timeout);
    }

    public KsqlTarget timeout(long timeout) {
        return new KsqlTarget(this.httpClient, this.socketAddress, this.localProperties, this.authHeader, this.host, this.subPath, this.additionalHeaders, timeout);
    }

    public RestResponse<ServerInfo> getServerInfo() {
        return this.get("/info", ServerInfo.class);
    }

    public RestResponse<HealthCheckResponse> getServerHealth() {
        return this.get("/healthcheck", HealthCheckResponse.class);
    }

    public CompletableFuture<RestResponse<HeartbeatResponse>> postAsyncHeartbeatRequest(KsqlHostInfoEntity host, long timestamp) {
        return this.executeRequestAsync(HttpMethod.POST, HEARTBEAT_PATH, new HeartbeatMessage(host, timestamp), r -> KsqlClientUtil.deserialize(r.getBody(), HeartbeatResponse.class));
    }

    public RestResponse<ClusterStatusResponse> getClusterStatus() {
        return this.get(CLUSTERSTATUS_PATH, ClusterStatusResponse.class);
    }

    public CompletableFuture<RestResponse<LagReportingResponse>> postAsyncLagReportingRequest(LagReportingMessage lagReportingMessage) {
        return this.executeRequestAsync(HttpMethod.POST, LAG_REPORT_PATH, lagReportingMessage, r -> KsqlClientUtil.deserialize(r.getBody(), LagReportingResponse.class));
    }

    public RestResponse<CommandStatuses> getStatuses() {
        return this.get(STATUS_PATH, CommandStatuses.class);
    }

    public RestResponse<CommandStatus> getStatus(String commandId) {
        return this.get("/status/" + commandId, CommandStatus.class);
    }

    public RestResponse<ServerMetadata> getServerMetadata() {
        return this.get(SERVER_METADATA_PATH, ServerMetadata.class);
    }

    public RestResponse<ServerClusterId> getServerMetadataId() {
        return this.get(SERVER_METADATA_ID_PATH, ServerClusterId.class);
    }

    public RestResponse<Boolean> getIsValidRequest(String propertyName) {
        return this.get(IS_VALID_PATH + propertyName, Boolean.class);
    }

    public RestResponse<KsqlEntityList> postKsqlRequest(String ksql, Map<String, ?> requestProperties, Optional<Long> previousCommandSeqNum) {
        return this.post(KSQL_PATH, this.createKsqlRequest(ksql, requestProperties, previousCommandSeqNum), r -> KsqlClientUtil.deserialize(r.getBody(), KsqlEntityList.class));
    }

    public RestResponse<Integer> postQueryRequest(String ksql, Map<String, ?> requestProperties, Optional<Long> previousCommandSeqNum, WriteStream<List<StreamedRow>> rowConsumer, CompletableFuture<Void> shouldCloseConnection, Function<StreamedRow, StreamedRow> addHostInfo) {
        AtomicInteger rowCount = new AtomicInteger(0);
        return this.post(QUERY_PATH, this.createKsqlRequest(ksql, requestProperties, previousCommandSeqNum), rowCount::get, rows -> {
            List<StreamedRow> streamedRows = KsqlTargetUtil.toRows(rows, addHostInfo);
            rowCount.addAndGet(streamedRows.size());
            return streamedRows;
        }, "\n", rowConsumer, shouldCloseConnection);
    }

    public RestResponse<List<StreamedRow>> postQueryRequest(String ksql, Map<String, ?> requestProperties, Optional<Long> previousCommandSeqNum) {
        return this.post(QUERY_PATH, this.createKsqlRequest(ksql, requestProperties, previousCommandSeqNum), KsqlTarget::toRows);
    }

    public RestResponse<List<StreamedRow>> postQueryStreamRequestProto(String ksql, Map<String, Object> requestProperties) {
        QueryStreamArgs queryStreamArgs = new QueryStreamArgs(ksql, this.localProperties.toMap(), Collections.emptyMap(), requestProperties);
        return this.executeRequestSync(HttpMethod.POST, QUERY_STREAM_PATH, queryStreamArgs, KsqlTarget::toRowsFromProto, Optional.of(KsqlMediaType.KSQL_V1_PROTOBUF.mediaType()));
    }

    public RestResponse<StreamPublisher<StreamedRow>> postQueryRequestStreamed(String sql, Map<String, ?> requestProperties, Optional<Long> previousCommandSeqNum) {
        return this.executeQueryRequestWithStreamResponse(sql, requestProperties, previousCommandSeqNum, buff -> KsqlClientUtil.deserialize(buff, StreamedRow.class));
    }

    public CompletableFuture<RestResponse<StreamPublisher<StreamedRow>>> postQueryRequestStreamedAsync(String sql, Map<String, ?> requestProperties) {
        return this.executeQueryStreamRequest(sql, requestProperties, KsqlTargetUtil::toRowFromDelimited);
    }

    public RestResponse<StreamPublisher<String>> postPrintTopicRequest(String ksql, Optional<Long> previousCommandSeqNum) {
        return this.executeQueryRequestWithStreamResponse(ksql, Collections.emptyMap(), previousCommandSeqNum, Object::toString);
    }

    private KsqlRequest createKsqlRequest(String ksql, Map<String, ?> requestProperties, Optional<Long> previousCommandSeqNum) {
        return new KsqlRequest(ksql, this.localProperties.toMap(), requestProperties, (Long)previousCommandSeqNum.orElse(null));
    }

    private <T> RestResponse<T> get(String path, Class<T> type) {
        return this.executeRequestSync(HttpMethod.GET, path, null, r -> KsqlClientUtil.deserialize(r.getBody(), type), Optional.empty());
    }

    private <T> RestResponse<T> post(String path, Object jsonEntity, Function<ResponseWithBody, T> mapper) {
        return this.executeRequestSync(HttpMethod.POST, path, jsonEntity, mapper, Optional.empty());
    }

    private <R, T> RestResponse<R> post(String path, Object jsonEntity, Supplier<R> responseSupplier, Function<Buffer, T> mapper, String delimiter, WriteStream<T> chunkHandler, CompletableFuture<Void> shouldCloseConnection) {
        return this.executeRequestSync(HttpMethod.POST, path, jsonEntity, responseSupplier, mapper, delimiter, chunkHandler, shouldCloseConnection);
    }

    private <T> CompletableFuture<RestResponse<T>> executeRequestAsync(HttpMethod httpMethod, String path, Object jsonEntity, Function<ResponseWithBody, T> mapper) {
        return this.executeAsync(httpMethod, path, Optional.empty(), jsonEntity, mapper, (resp, vcf) -> resp.bodyHandler(buff -> vcf.complete(new ResponseWithBody((HttpClientResponse)resp, (Buffer)buff))));
    }

    private <T> RestResponse<T> executeRequestSync(HttpMethod httpMethod, String path, Object requestBody, Function<ResponseWithBody, T> mapper, Optional<String> mediaType) {
        return this.executeSync(httpMethod, path, mediaType, requestBody, mapper, (resp, vcf) -> resp.bodyHandler(buff -> vcf.complete(new ResponseWithBody((HttpClientResponse)resp, (Buffer)buff))));
    }

    private <R, T> RestResponse<R> executeRequestSync(HttpMethod httpMethod, String path, Object requestBody, Supplier<R> responseSupplier, Function<Buffer, T> chunkMapper, String delimiter, WriteStream<T> chunkHandler, CompletableFuture<Void> shouldCloseConnection) {
        return this.executeSync(httpMethod, path, Optional.empty(), requestBody, resp -> responseSupplier.get(), (resp, vcf) -> {
            if (resp.statusCode() != 200) {
                try {
                    String msg = "Closing connection since status code is " + resp.statusCode() + ", body is " + String.valueOf(resp.body());
                    resp.request().connection().close();
                    vcf.completeExceptionally(new KsqlRestClientException(msg));
                }
                catch (Throwable closing) {
                    log.error("Error while handling close", closing);
                    vcf.completeExceptionally(closing);
                }
                return;
            }
            Object readStream = resp != null && resp.request().connection().isSsl() ? new BufferCopyStream((ReadStream<Buffer>)resp) : resp;
            RecordParser recordParser = RecordParser.newDelimited((String)delimiter, (ReadStream)readStream);
            AtomicBoolean end = new AtomicBoolean(false);
            BufferMapWriteStream ws = new BufferMapWriteStream(chunkMapper, chunkHandler);
            recordParser.exceptionHandler(vcf::completeExceptionally);
            recordParser.pipe().endOnSuccess(false).to(ws, ar -> {
                end.set(true);
                if (ar.succeeded()) {
                    vcf.complete(new ResponseWithBody((HttpClientResponse)resp, Buffer.buffer()));
                }
                if (ar.failed()) {
                    log.error("Error while handling response.", ar.cause());
                    vcf.completeExceptionally(ar.cause());
                }
            });
            Context context = Vertx.currentContext();
            shouldCloseConnection.handle((v, t) -> {
                context.runOnContext(v2 -> {
                    if (!end.get()) {
                        try {
                            resp.request().connection().close();
                            vcf.completeExceptionally(new KsqlRestClientException("Closing connection"));
                        }
                        catch (Throwable closing) {
                            log.error("Error while handling close", closing);
                            vcf.completeExceptionally(closing);
                        }
                    }
                });
                return null;
            });
        });
    }

    private <T> RestResponse<StreamPublisher<T>> executeQueryRequestWithStreamResponse(String ksql, Map<String, ?> requestProperties, Optional<Long> previousCommandSeqNum, Function<Buffer, T> mapper) {
        KsqlRequest ksqlRequest = this.createKsqlRequest(ksql, requestProperties, previousCommandSeqNum);
        AtomicReference pubRef = new AtomicReference();
        return this.executeSync(HttpMethod.POST, QUERY_PATH, Optional.empty(), ksqlRequest, resp -> (StreamPublisher)((Object)((Object)pubRef.get())), (resp, vcf) -> {
            if (resp.statusCode() == 200) {
                pubRef.set(new StreamPublisher(Vertx.currentContext(), (HttpClientResponse)resp, mapper, (CompletableFuture<ResponseWithBody>)vcf, true));
                vcf.complete(new ResponseWithBody((HttpClientResponse)resp));
            } else {
                resp.bodyHandler(body -> vcf.complete(new ResponseWithBody((HttpClientResponse)resp, (Buffer)body)));
            }
        });
    }

    private <T> CompletableFuture<RestResponse<StreamPublisher<T>>> executeQueryStreamRequest(String ksql, Map<String, ?> requestProperties, Function<Buffer, T> mapper) {
        Map<String, Object> requestPropertiesObject = requestProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        QueryStreamArgs queryStreamArgs = new QueryStreamArgs(ksql, this.localProperties.toMap(), Collections.emptyMap(), requestPropertiesObject);
        AtomicReference pubRef = new AtomicReference();
        return this.executeAsync(HttpMethod.POST, QUERY_STREAM_PATH, Optional.of("application/vnd.ksqlapi.delimited.v1"), queryStreamArgs, resp -> (StreamPublisher)((Object)((Object)pubRef.get())), (resp, vcf) -> {
            if (resp.statusCode() == 200) {
                pubRef.set(new StreamPublisher(Vertx.currentContext(), (HttpClientResponse)resp, mapper, (CompletableFuture<ResponseWithBody>)vcf, false));
                vcf.complete(new ResponseWithBody((HttpClientResponse)resp));
            } else {
                resp.bodyHandler(body -> vcf.complete(new ResponseWithBody((HttpClientResponse)resp, (Buffer)body)));
            }
        });
    }

    private <T> RestResponse<T> executeSync(HttpMethod httpMethod, String path, Optional<String> mediaType, Object requestBody, Function<ResponseWithBody, T> mapper, BiConsumer<HttpClientResponse, CompletableFuture<ResponseWithBody>> responseHandler) {
        ResponseWithBody response;
        CompletableFuture<ResponseWithBody> vcf = this.execute(httpMethod, path, mediaType, requestBody, responseHandler);
        try {
            response = vcf.get();
        }
        catch (Exception e) {
            throw new KsqlRestClientException("Error issuing " + String.valueOf(httpMethod) + " to KSQL server. path:" + path, e);
        }
        return KsqlClientUtil.toRestResponse(response, path, mapper);
    }

    private <T> CompletableFuture<RestResponse<T>> executeAsync(HttpMethod httpMethod, String path, Optional<String> mediaType, Object requestBody, Function<ResponseWithBody, T> mapper, BiConsumer<HttpClientResponse, CompletableFuture<ResponseWithBody>> responseHandler) {
        CompletableFuture<ResponseWithBody> vcf = this.execute(httpMethod, path, mediaType, requestBody, responseHandler);
        return vcf.thenApply(response -> KsqlClientUtil.toRestResponse(response, path, mapper));
    }

    private CompletableFuture<ResponseWithBody> execute(HttpMethod httpMethod, String path, Optional<String> mediaType, Object requestBody, BiConsumer<HttpClientResponse, CompletableFuture<ResponseWithBody>> responseHandler) {
        VertxCompletableFuture vcf = new VertxCompletableFuture();
        RequestOptions options = new RequestOptions();
        options.setMethod(httpMethod);
        options.setServer(this.socketAddress);
        options.setPort(Integer.valueOf(this.socketAddress.port()));
        options.setHost(this.host);
        options.setURI(this.subPath + path);
        options.setTimeout(this.timeout);
        this.httpClient.request(options, ar -> {
            if (ar.failed()) {
                vcf.completeExceptionally(ar.cause());
                return;
            }
            HttpClientRequest httpClientRequest = (HttpClientRequest)ar.result();
            httpClientRequest.response(response -> {
                if (response.failed()) {
                    vcf.completeExceptionally(response.cause());
                }
                responseHandler.accept((HttpClientResponse)response.result(), (CompletableFuture<ResponseWithBody>)vcf);
            });
            httpClientRequest.exceptionHandler(arg_0 -> vcf.completeExceptionally(arg_0));
            if (mediaType.isPresent()) {
                httpClientRequest.putHeader("Accept", (String)mediaType.get());
            } else {
                httpClientRequest.putHeader("Accept", "application/json");
            }
            this.authHeader.ifPresent(v -> httpClientRequest.putHeader("Authorization", v));
            this.additionalHeaders.forEach((arg_0, arg_1) -> ((HttpClientRequest)httpClientRequest).putHeader(arg_0, arg_1));
            if (requestBody != null) {
                httpClientRequest.end(KsqlClientUtil.serialize(requestBody));
            } else {
                httpClientRequest.end();
            }
        });
        return vcf;
    }

    private static List<StreamedRow> toRows(ResponseWithBody resp) {
        return KsqlTargetUtil.toRows(resp.getBody(), (Function<StreamedRow, StreamedRow>)Functions.identity());
    }

    private static List<StreamedRow> toRowsFromProto(ResponseWithBody resp) {
        return KsqlTargetUtil.toRows(resp.getBody(), (Function<StreamedRow, StreamedRow>)Functions.identity());
    }
}

