/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.common.runtime;

import java.util.Deque;
import java.util.concurrent.RejectedExecutionException;
import org.apache.kafka.coordinator.common.runtime.EventAccumulator;
import org.apache.kafka.coordinator.common.runtime.EventOrigin;

public class BoundedEventAccumulator<K, T extends EventAccumulator.Event<K>>
extends EventAccumulator<K, T> {
    private final int maxEventsPerKey;

    public BoundedEventAccumulator(int maxEventsPerKey) {
        if (maxEventsPerKey <= 0) {
            throw new IllegalArgumentException("maxEventsPerKey must be positive, got " + maxEventsPerKey);
        }
        this.maxEventsPerKey = maxEventsPerKey;
    }

    @Override
    void validateAddEvent(T event, Deque<T> queue) throws QueueFullException {
        if (event.origin() == EventOrigin.EXTERNAL && queue.size() >= this.maxEventsPerKey) {
            throw new QueueFullException("Can't accept an event because the number of events for the partition " + String.valueOf(event.key()) + " is already at the maximum of " + this.maxEventsPerKey);
        }
    }

    static class QueueFullException
    extends RejectedExecutionException {
        QueueFullException(String message) {
            super(message);
        }
    }
}

