/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.ScopeAnnotation;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.internal.MoreTypes;
import com.google.inject.multibindings.Multibinder;
import com.netflix.governator.annotations.AutoBindSingleton;
import com.netflix.governator.guice.lazy.LazySingletonScope;
import com.netflix.governator.spi.AnnotatedClassScanner;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Scope;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoBindSingletonAnnotatedClassScanner
implements AnnotatedClassScanner {
    private static final Logger LOG = LoggerFactory.getLogger(AutoBindSingletonAnnotatedClassScanner.class);

    @Override
    public Class<? extends Annotation> annotationClass() {
        return AutoBindSingleton.class;
    }

    @Override
    public <T> void applyTo(Binder binder, Annotation annotation, Key<T> key) {
        AutoBindSingleton abs = (AutoBindSingleton)annotation;
        Class clazz = key.getTypeLiteral().getRawType();
        if (Module.class.isAssignableFrom(clazz)) {
            try {
                binder.install((Module)clazz.newInstance());
            }
            catch (Exception e) {
                binder.addError("Failed to install @AutoBindSingleton module " + clazz.getName(), new Object[0]);
                binder.addError((Throwable)e);
            }
        } else {
            this.bindAutoBindSingleton(binder, abs, clazz);
        }
    }

    private void bindAutoBindSingleton(Binder binder, AutoBindSingleton annotation, Class<?> clazz) {
        Class<?> annotationBaseClass;
        LOG.info("Installing @AutoBindSingleton '{}'", (Object)clazz.getName());
        LOG.info("***** @AutoBindSingleton for '{}' is deprecated as of 2015-10-10.\nPlease use a Guice module with bind({}.class).asEagerSingleton() instead.\nSee https://github.com/Netflix/governator/wiki/Auto-Binding", (Object)clazz.getName(), (Object)clazz.getSimpleName());
        Singleton singletonAnnotation = clazz.getAnnotation(Singleton.class);
        if (singletonAnnotation == null) {
            LOG.info("***** {} should also be annotated with @Singleton to ensure singleton behavior", (Object)clazz.getName());
        }
        if ((annotationBaseClass = this.getAnnotationBaseClass(annotation)) != Void.class) {
            Object foundBindingClass = this.searchForBaseClass(clazz, annotationBaseClass, Sets.newHashSet());
            Preconditions.checkArgument((foundBindingClass != null ? 1 : 0) != 0, (Object)String.format("AutoBindSingleton class %s does not implement or extend %s", clazz.getName(), annotationBaseClass.getName()));
            if (foundBindingClass instanceof Class) {
                if (annotation.multiple()) {
                    Multibinder multibinder = Multibinder.newSetBinder((Binder)binder, (Class)((Class)foundBindingClass));
                    this.applyScope(multibinder.addBinding().to(clazz), clazz, annotation);
                } else {
                    this.applyScope(binder.withSource((Object)this.getCurrentStackElement()).bind((Class)foundBindingClass).to(clazz), clazz, annotation);
                }
            } else if (foundBindingClass instanceof Type) {
                TypeLiteral typeLiteral = TypeLiteral.get((Type)((Type)foundBindingClass));
                if (annotation.multiple()) {
                    this.applyScope(Multibinder.newSetBinder((Binder)binder, (TypeLiteral)typeLiteral).addBinding().to(clazz), clazz, annotation);
                } else {
                    this.applyScope(binder.withSource((Object)this.getCurrentStackElement()).bind(typeLiteral).to(clazz), clazz, annotation);
                }
            } else {
                binder.addError("Unexpected binding class: " + foundBindingClass, new Object[0]);
            }
        } else {
            Preconditions.checkState((!annotation.multiple() ? 1 : 0) != 0, (Object)"@AutoBindSingleton(multiple=true) must have either value or baseClass set");
            this.applyScope((ScopedBindingBuilder)binder.withSource((Object)this.getCurrentStackElement()).bind(clazz), clazz, annotation);
        }
    }

    private StackTraceElement getCurrentStackElement() {
        return Thread.currentThread().getStackTrace()[1];
    }

    private void applyScope(ScopedBindingBuilder builder, Class<?> clazz, AutoBindSingleton annotation) {
        if (!this.hasScopeAnnotation(clazz)) {
            if (annotation.eager()) {
                builder.asEagerSingleton();
            } else {
                builder.in(LazySingletonScope.get());
            }
        }
    }

    private boolean hasScopeAnnotation(Class<?> clazz) {
        Annotation scopeAnnotation = null;
        for (Annotation annot : clazz.getAnnotations()) {
            if (!annot.annotationType().isAnnotationPresent(ScopeAnnotation.class) && !annot.annotationType().isAnnotationPresent(Scope.class)) continue;
            Preconditions.checkState((scopeAnnotation == null ? 1 : 0) != 0, (Object)"Multiple scopes not allowed");
            scopeAnnotation = annot;
        }
        return scopeAnnotation != null;
    }

    private Class<?> getAnnotationBaseClass(AutoBindSingleton annotation) {
        Class annotationValue = annotation.value();
        Class annotationBaseClass = annotation.baseClass();
        Preconditions.checkState((annotationValue == Void.class || annotationBaseClass == Void.class ? 1 : 0) != 0, (Object)"@AutoBindSingleton cannot have both value and baseClass set");
        return annotationBaseClass != Void.class ? annotationBaseClass : annotationValue;
    }

    private Object searchForBaseClass(Class<?> clazz, Class<?> annotationBaseClass, Set<Object> usedSet) {
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(annotationBaseClass)) {
            return clazz;
        }
        if (!usedSet.add(clazz)) {
            return null;
        }
        for (Type type : clazz.getGenericInterfaces()) {
            if (!MoreTypes.getRawType((Type)type).equals(annotationBaseClass)) continue;
            return type;
        }
        if (clazz.getGenericSuperclass() != null && MoreTypes.getRawType((Type)clazz.getGenericSuperclass()).equals(annotationBaseClass)) {
            return clazz.getGenericSuperclass();
        }
        for (Type type : clazz.getInterfaces()) {
            Object foundBindingClass = this.searchForBaseClass((Class<?>)type, annotationBaseClass, usedSet);
            if (foundBindingClass == null) continue;
            return foundBindingClass;
        }
        return this.searchForBaseClass(clazz.getSuperclass(), annotationBaseClass, usedSet);
    }
}

