/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.spi.Element;
import com.google.inject.spi.ElementVisitor;
import com.google.inject.spi.Elements;
import com.google.inject.util.Modules;
import com.netflix.governator.LifecycleInjector;
import com.netflix.governator.LifecycleInjectorCreator;
import com.netflix.governator.spi.InjectorCreator;
import com.netflix.governator.spi.ModuleTransformer;
import com.netflix.governator.visitors.IsNotStaticInjectionVisitor;
import com.netflix.governator.visitors.KeyTracingVisitor;
import com.netflix.governator.visitors.WarnOfStaticInjectionVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InjectorBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InjectorBuilder.class);
    private static final Stage LAZY_SINGLETONS_STAGE = Stage.DEVELOPMENT;
    private Module module;

    public static InjectorBuilder fromModule(Module module) {
        return new InjectorBuilder(module);
    }

    public static InjectorBuilder fromModules(Module ... additionalModules) {
        return new InjectorBuilder(Modules.combine((Module[])additionalModules));
    }

    public static InjectorBuilder fromModules(List<Module> modules) {
        return new InjectorBuilder(Modules.combine(modules));
    }

    private InjectorBuilder(Module module) {
        this.module = module;
    }

    public InjectorBuilder overrideWith(Module ... modules) {
        return this.overrideWith(Arrays.asList(modules));
    }

    public InjectorBuilder overrideWith(Collection<Module> modules) {
        this.module = Modules.override((Module[])new Module[]{this.module}).with(modules);
        return this;
    }

    public InjectorBuilder combineWith(Module ... modules) {
        ArrayList<Module> m = new ArrayList<Module>();
        m.add(this.module);
        m.addAll(Arrays.asList(modules));
        this.module = Modules.combine(m);
        return this;
    }

    @Deprecated
    public InjectorBuilder traceEachElement(ElementVisitor<String> visitor) {
        return this.forEachElement(visitor, message -> LOG.debug(message));
    }

    public <T> InjectorBuilder forEachElement(ElementVisitor<T> visitor, Consumer<T> consumer) {
        Elements.getElements((Module[])new Module[]{this.module}).forEach(element -> Optional.ofNullable(element.acceptVisitor(visitor)).ifPresent(consumer));
        return this;
    }

    public <T> InjectorBuilder forEachElement(ElementVisitor<T> visitor) {
        Elements.getElements((Module[])new Module[]{this.module}).forEach(element -> element.acceptVisitor(visitor));
        return this;
    }

    public InjectorBuilder traceEachKey() {
        return this.forEachElement((ElementVisitor)new KeyTracingVisitor(), message -> LOG.debug(message));
    }

    public InjectorBuilder warnOfStaticInjections() {
        return this.forEachElement((ElementVisitor)new WarnOfStaticInjectionVisitor(), message -> LOG.debug(message));
    }

    public InjectorBuilder map(ModuleTransformer transformer) {
        this.module = transformer.transform(this.module);
        return this;
    }

    public InjectorBuilder filter(ElementVisitor<Boolean> predicate) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Element element : Elements.getElements((Stage)Stage.TOOL, (Module[])new Module[]{this.module})) {
            if (!((Boolean)element.acceptVisitor(predicate)).booleanValue()) continue;
            elements.add(element);
        }
        this.module = Elements.getModule(elements);
        return this;
    }

    public InjectorBuilder stripStaticInjections() {
        return this.filter((ElementVisitor<Boolean>)new IsNotStaticInjectionVisitor());
    }

    public List<Element> getElements() {
        return Elements.getElements((Stage)Stage.TOOL, (Module[])new Module[]{this.module});
    }

    public <I extends Injector> I createInjector(Stage stage, InjectorCreator<I> creator) {
        return creator.createInjector(stage, this.module);
    }

    public <I extends Injector> I createInjector(InjectorCreator<I> creator) {
        return creator.createInjector(LAZY_SINGLETONS_STAGE, this.module);
    }

    public LifecycleInjector createInjector(Stage stage) {
        return this.createInjector(stage, new LifecycleInjectorCreator());
    }

    public LifecycleInjector createInjector() {
        return this.createInjector(LAZY_SINGLETONS_STAGE, new LifecycleInjectorCreator());
    }
}

