/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.AbstractModule;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import com.netflix.governator.LifecycleManager;
import com.netflix.governator.annotations.SuppressLifecycleUninitialized;
import com.netflix.governator.spi.LifecycleListener;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

public final class LifecycleListenerModule
extends AbstractModule {
    private LifecycleListenerProvisionListener provisionListener = new LifecycleListenerProvisionListener();

    protected void configure() {
        this.requestStaticInjection(new Class[]{LifecycleListenerProvisionListener.class});
        this.bind(LifecycleListenerProvisionListener.class).toInstance((Object)this.provisionListener);
        this.bindListener(Matchers.any(), new ProvisionListener[]{this.provisionListener});
    }

    public boolean equals(Object obj) {
        return ((Object)((Object)this)).getClass() == obj.getClass();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public String toString() {
        return "LifecycleListenerModule[]";
    }

    @Singleton
    @SuppressLifecycleUninitialized
    static class LifecycleListenerProvisionListener
    implements ProvisionListener {
        private LifecycleManager manager;
        private List<LifecycleListener> pendingLifecycleListeners = new ArrayList<LifecycleListener>();

        LifecycleListenerProvisionListener() {
        }

        @Inject
        public static void initialize(LifecycleManager manager, LifecycleListenerProvisionListener provisionListener) {
            provisionListener.manager = manager;
            for (LifecycleListener l : provisionListener.pendingLifecycleListeners) {
                manager.addListener(l);
            }
            provisionListener.pendingLifecycleListeners.clear();
        }

        public String toString() {
            return "LifecycleListenerProvisionListener[]";
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            Object injectee = provision.provision();
            if (injectee != null && injectee instanceof LifecycleListener) {
                if (this.manager == null) {
                    this.pendingLifecycleListeners.add((LifecycleListener)injectee);
                } else {
                    this.manager.addListener((LifecycleListener)injectee);
                }
            }
        }
    }
}

