/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.ProvisionException;
import com.google.inject.matcher.Matchers;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.MultibindingsScanner;
import com.google.inject.spi.ProvisionListener;
import com.netflix.governator.AbstractLifecycleListener;
import com.netflix.governator.GovernatorFeatures;
import com.netflix.governator.LifecycleAction;
import com.netflix.governator.LifecycleFeature;
import com.netflix.governator.LifecycleManager;
import com.netflix.governator.ManagedInstanceAction;
import com.netflix.governator.annotations.SuppressLifecycleUninitialized;
import com.netflix.governator.internal.GovernatorFeatureSet;
import com.netflix.governator.internal.JSR250LifecycleAction;
import com.netflix.governator.internal.PostConstructLifecycleFeature;
import com.netflix.governator.internal.PreDestroyLifecycleFeature;
import com.netflix.governator.internal.PreDestroyMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LifecycleModule
extends AbstractModule {
    private static final Logger LOG = LoggerFactory.getLogger(LifecycleModule.class);
    private LifecycleProvisionListener provisionListener = new LifecycleProvisionListener();

    protected void configure() {
        this.requestStaticInjection(new Class[]{LifecycleProvisionListener.class});
        this.bind(LifecycleProvisionListener.class).toInstance((Object)this.provisionListener);
        this.bindListener(Matchers.any(), new ProvisionListener[]{this.provisionListener});
        Multibinder.newSetBinder((Binder)this.binder(), LifecycleFeature.class);
        this.install(MultibindingsScanner.asModule());
    }

    public boolean equals(Object obj) {
        return ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public String toString() {
        return "LifecycleModule@" + System.identityHashCode((Object)this);
    }

    @Singleton
    @SuppressLifecycleUninitialized
    static class LifecycleProvisionListener
    extends AbstractLifecycleListener
    implements ProvisionListener {
        private final ConcurrentMap<Class<?>, TypeLifecycleActions> cache = new ConcurrentHashMap(4096);
        private Set<LifecycleFeature> features;
        private final AtomicBoolean isShutdown = new AtomicBoolean();
        private PostConstructLifecycleFeature postConstructFeature;
        private PreDestroyLifecycleFeature preDestroyFeature;
        private PreDestroyMonitor preDestroyMonitor;
        private boolean shutdownOnFailure = true;

        LifecycleProvisionListener() {
        }

        @javax.inject.Inject
        public static void initialize(Injector injector, OptionalArgs args, LifecycleManager manager, LifecycleProvisionListener provisionListener, Set<LifecycleFeature> features) {
            provisionListener.features = features;
            provisionListener.shutdownOnFailure = args.hasShutdownOnFailure();
            JSR250LifecycleAction.ValidationMode validationMode = args.getJsr250ValidationMode();
            provisionListener.postConstructFeature = new PostConstructLifecycleFeature(validationMode);
            provisionListener.preDestroyFeature = new PreDestroyLifecycleFeature(validationMode);
            provisionListener.preDestroyMonitor = new PreDestroyMonitor(injector.getScopeBindings());
            LOG.debug("LifecycleProvisionListener initialized with features {}", features);
        }

        public TypeLifecycleActions getOrCreateActions(Class<?> type) {
            TypeLifecycleActions actions = (TypeLifecycleActions)this.cache.get(type);
            if (actions == null) {
                actions = new TypeLifecycleActions();
                for (LifecycleFeature feature : this.features) {
                    actions.postConstructActions.addAll(feature.getActionsForType(type));
                }
                actions.postConstructActions.addAll(this.postConstructFeature.getActionsForType(type));
                actions.preDestroyActions.addAll(this.preDestroyFeature.getActionsForType(type));
                TypeLifecycleActions existing = this.cache.putIfAbsent(type, actions);
                if (existing != null) {
                    return existing;
                }
            }
            return actions;
        }

        @Override
        public synchronized void onStopped(Throwable optionalFailureReason) {
            if ((this.shutdownOnFailure || optionalFailureReason == null) && this.isShutdown.compareAndSet(false, true)) {
                try {
                    this.preDestroyMonitor.close();
                }
                catch (Exception e) {
                    LOG.error("failed closing preDestroyMonitor", (Throwable)e);
                }
            }
        }

        public String toString() {
            return "LifecycleProvisionListener@" + System.identityHashCode(this);
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            Object injectee = provision.provision();
            if (injectee == null) {
                return;
            }
            if (this.features == null) {
                if (!injectee.getClass().isAnnotationPresent(SuppressLifecycleUninitialized.class)) {
                    LOG.debug("LifecycleProvisionListener not initialized yet : {}", injectee.getClass());
                }
                return;
            }
            Object source = provision.getBinding().getSource();
            if (source != null && source.toString().contains("spring-guice")) {
                return;
            }
            TypeLifecycleActions actions = this.getOrCreateActions(injectee.getClass());
            if (!actions.postConstructActions.isEmpty()) {
                try {
                    new ManagedInstanceAction(injectee, actions.postConstructActions).call();
                }
                catch (Exception e) {
                    throw new ProvisionException("postConstruct failed", (Throwable)e);
                }
            }
            if (!actions.preDestroyActions.isEmpty()) {
                if (!this.isShutdown.get()) {
                    this.preDestroyMonitor.register(injectee, provision.getBinding(), (Iterable<LifecycleAction>)actions.preDestroyActions);
                } else {
                    LOG.warn("Already shutting down.  Shutdown methods {} on {} will not be invoked", actions.preDestroyActions, (Object)injectee.getClass().getName());
                }
            }
        }

        @SuppressLifecycleUninitialized
        @Singleton
        static class OptionalArgs {
            @Inject(optional=true)
            GovernatorFeatureSet governatorFeatures;

            OptionalArgs() {
            }

            boolean hasShutdownOnFailure() {
                return this.governatorFeatures == null ? true : this.governatorFeatures.get(GovernatorFeatures.SHUTDOWN_ON_ERROR);
            }

            JSR250LifecycleAction.ValidationMode getJsr250ValidationMode() {
                return this.governatorFeatures == null ? JSR250LifecycleAction.ValidationMode.LAX : (this.governatorFeatures.get(GovernatorFeatures.STRICT_JSR250_VALIDATION) != false ? JSR250LifecycleAction.ValidationMode.STRICT : JSR250LifecycleAction.ValidationMode.LAX);
            }
        }
    }

    static class TypeLifecycleActions {
        final List<LifecycleAction> postConstructActions = new ArrayList<LifecycleAction>();
        final List<LifecycleAction> preDestroyActions = new ArrayList<LifecycleAction>();

        TypeLifecycleActions() {
        }
    }
}

