/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.netflix.governator.ProvisionMetrics;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingProvisionMetricsVisitor
implements ProvisionMetrics.Visitor {
    private static final Logger LOG = LoggerFactory.getLogger(LoggingProvisionMetricsVisitor.class);
    int level = 1;
    int elementCount = 0;

    @Override
    public void visit(ProvisionMetrics.Element entry) {
        ++this.elementCount;
        LOG.info(String.format("%" + (this.level * 3 - 2) + "s%s%s : %d ms (%d ms)", "", entry.getKey().getTypeLiteral().toString(), entry.getKey().getAnnotation() == null ? "" : " [" + entry.getKey().getAnnotation() + "]", entry.getTotalDuration(TimeUnit.MILLISECONDS), entry.getDuration(TimeUnit.MILLISECONDS)));
        ++this.level;
        entry.accept(this);
        --this.level;
    }

    int getElementCount() {
        return this.elementCount;
    }
}

