/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.common.base.Preconditions;
import com.netflix.governator.spi.LifecycleListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class SafeLifecycleListener
extends WeakReference<LifecycleListener>
implements LifecycleListener {
    private static final Logger LOG = LoggerFactory.getLogger(SafeLifecycleListener.class);
    private final int delegateHash;
    private final String asString;

    public static SafeLifecycleListener wrap(LifecycleListener listener) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener argument must be non-null");
        return new SafeLifecycleListener(listener, null);
    }

    public static SafeLifecycleListener wrap(LifecycleListener listener, ReferenceQueue<LifecycleListener> refQueue) {
        Preconditions.checkNotNull((Object)listener, (Object)"listener argument must be non-null");
        return new SafeLifecycleListener(listener, refQueue);
    }

    private SafeLifecycleListener(LifecycleListener delegate, ReferenceQueue<LifecycleListener> refQueue) {
        super(delegate, refQueue);
        this.delegateHash = delegate.hashCode();
        this.asString = "SafeLifecycleListener@" + System.identityHashCode(this) + " [" + delegate.toString() + "]";
    }

    public void onStarted() {
        LifecycleListener delegate = (LifecycleListener)this.get();
        if (delegate != null) {
            LOG.info("Starting '{}'", (Object)delegate);
            delegate.onStarted();
        }
    }

    public void onStopped(Throwable t) {
        LifecycleListener delegate = (LifecycleListener)this.get();
        if (delegate != null) {
            if (t != null) {
                LOG.info("Stopping '{}' due to '{}@{}'", new Object[]{delegate, t.getClass().getSimpleName(), System.identityHashCode(t)});
            } else {
                LOG.info("Stopping '{}'", (Object)delegate);
            }
            try {
                delegate.onStopped(t);
            }
            catch (Exception e) {
                LOG.info("onStopped failed for {}", (Object)delegate, (Object)e);
            }
        }
    }

    public String toString() {
        return this.asString;
    }

    public int hashCode() {
        return this.delegateHash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LifecycleListener delegate = (LifecycleListener)this.get();
        if (delegate != null) {
            LifecycleListener otherDelegate = (LifecycleListener)((SafeLifecycleListener)obj).get();
            return delegate == otherDelegate || delegate.equals(otherDelegate);
        }
        return false;
    }
}

