/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.ProvisionException;
import com.google.inject.multibindings.Multibinder;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;

public class ServiceLoaderModuleBuilder {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private Boolean installed = false;

    public ServiceLoaderModuleBuilder usingClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ServiceLoaderModuleBuilder forInstalledServices(Boolean installed) {
        this.installed = installed;
        return this;
    }

    public <S extends Module> Module loadModules(Class<S> type) {
        return new BaseModule<S>((Class)type){

            @Override
            protected void onService(S service) {
                this.install((Module)service);
            }
        };
    }

    public <S> Module loadServices(final Class<S> type) {
        return new BaseModule<S>(type){

            @Override
            protected void onService(S service) {
                this.requestInjection(service);
                Multibinder.newSetBinder((Binder)this.binder(), (Class)type).addBinding().toInstance(service);
            }
        };
    }

    private abstract class BaseModule<S>
    extends AbstractModule {
        private final Class<S> type;

        public BaseModule(Class<S> type) {
            this.type = type;
        }

        protected final void configure() {
            Callable loader;
            if (ServiceLoaderModuleBuilder.this.installed.booleanValue()) {
                if (ServiceLoaderModuleBuilder.this.classLoader != null) {
                    throw new RuntimeException("Class loader may not be combined with loading installed services");
                }
                loader = new Callable<ServiceLoader<S>>(){

                    @Override
                    public ServiceLoader<S> call() throws Exception {
                        return ServiceLoader.loadInstalled(BaseModule.this.type);
                    }
                };
            } else {
                loader = ServiceLoaderModuleBuilder.this.classLoader != null ? new Callable<ServiceLoader<S>>(){

                    @Override
                    public ServiceLoader<S> call() throws Exception {
                        return ServiceLoader.load(BaseModule.this.type, ServiceLoaderModuleBuilder.this.classLoader);
                    }
                } : new Callable<ServiceLoader<S>>(){

                    @Override
                    public ServiceLoader<S> call() throws Exception {
                        return ServiceLoader.load(BaseModule.this.type);
                    }
                };
            }
            try {
                for (Object service : loader.call()) {
                    this.onService(service);
                }
            }
            catch (Exception e) {
                throw new ProvisionException("Failed to load services for '" + this.type + "'", (Throwable)e);
            }
        }

        protected abstract void onService(S var1);
    }
}

