/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator;

import com.google.inject.Key;
import com.netflix.governator.ProvisionMetrics;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.inject.Singleton;

@Singleton
public final class SimpleProvisionMetrics
implements ProvisionMetrics {
    private final ConcurrentMap<Long, Node> threads = new ConcurrentHashMap<Long, Node>();

    private Node currentNode() {
        return this.threads.computeIfAbsent(Thread.currentThread().getId(), id -> new Node());
    }

    @Override
    public void push(Key<?> key) {
        this.currentNode().push(new Entry(key));
    }

    @Override
    public void pop() {
        this.currentNode().pop();
    }

    @Override
    public void accept(ProvisionMetrics.Visitor visitor) {
        this.threads.forEach((id, data) -> data.accept(visitor));
    }

    public static class Entry
    implements ProvisionMetrics.Element {
        final Key<?> key;
        final List<Entry> children = new ArrayList<Entry>();
        final long startTime = System.nanoTime();
        long endTime;

        Entry(Key<?> key) {
            this.key = key;
        }

        void add(Entry child) {
            this.children.add(child);
        }

        void finish() {
            this.endTime = System.nanoTime();
        }

        @Override
        public Key<?> getKey() {
            return this.key;
        }

        @Override
        public void accept(ProvisionMetrics.Visitor visit) {
            for (Entry entry : this.children) {
                visit.visit(entry);
            }
        }

        @Override
        public long getDuration(TimeUnit units) {
            long childDuration = 0L;
            for (Entry child : this.children) {
                childDuration += child.getTotalDuration(units);
            }
            return this.getTotalDuration(units) - childDuration;
        }

        @Override
        public long getTotalDuration(TimeUnit units) {
            return units.convert(this.endTime - this.startTime, TimeUnit.NANOSECONDS);
        }
    }

    private static class Node {
        List<Entry> children = new ArrayList<Entry>();
        Stack<Entry> stack = new Stack();

        private Node() {
        }

        void accept(ProvisionMetrics.Visitor visitor) {
            this.children.forEach(entry -> visitor.visit((ProvisionMetrics.Element)entry));
        }

        void push(Entry entry) {
            if (this.stack.isEmpty()) {
                this.children.add(entry);
            } else {
                this.stack.peek().add(entry);
            }
            this.stack.push(entry);
        }

        void pop() {
            this.stack.pop().finish();
        }
    }
}

