/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.event;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.InjectionListener;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import com.netflix.governator.event.ApplicationEvent;
import com.netflix.governator.event.ApplicationEventDispatcher;
import com.netflix.governator.event.ApplicationEventListener;
import com.netflix.governator.event.EventListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ApplicationEventModule
extends AbstractModule {
    protected void configure() {
        Provider dispatcherProvider = this.binder().getProvider(ApplicationEventDispatcher.class);
        this.bindListener(Matchers.any(), new ApplicationEventSubscribingTypeListener((javax.inject.Provider<ApplicationEventDispatcher>)dispatcherProvider));
        this.bindListener(Matchers.any(), new ProvisionListener[]{new ApplicationEventSubscribingProvisionListener((javax.inject.Provider<ApplicationEventDispatcher>)dispatcherProvider)});
    }

    public boolean equals(Object obj) {
        return ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public String toString() {
        return "ApplicationEventModule[]";
    }

    private static class ApplicationEventSubscribingProvisionListener
    implements ProvisionListener {
        private final javax.inject.Provider<ApplicationEventDispatcher> dispatcherProvider;

        public ApplicationEventSubscribingProvisionListener(javax.inject.Provider<ApplicationEventDispatcher> dispatcherProvider) {
            this.dispatcherProvider = dispatcherProvider;
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
            Object provisioned = provision.provision();
            if (provisioned != null && provisioned instanceof ApplicationEventListener) {
                ((ApplicationEventDispatcher)this.dispatcherProvider.get()).registerListener((ApplicationEventListener)provisioned);
            }
        }
    }

    private static class ApplicationEventSubscribingTypeListener
    implements TypeListener {
        private static final Logger LOG = LoggerFactory.getLogger(ApplicationEventSubscribingTypeListener.class);
        private final javax.inject.Provider<ApplicationEventDispatcher> dispatcherProvider;

        public ApplicationEventSubscribingTypeListener(javax.inject.Provider<ApplicationEventDispatcher> dispatcherProvider) {
            this.dispatcherProvider = dispatcherProvider;
        }

        public <I> void hear(TypeLiteral<I> type, TypeEncounter<I> encounter) {
            Class clazz = type.getRawType();
            final List<Method> handlerMethods = this.getAllDeclaredHandlerMethods(clazz);
            if (!handlerMethods.isEmpty()) {
                encounter.register((InjectionListener)new InjectionListener<Object>(){

                    public void afterInjection(Object injectee) {
                        for (Method handlerMethod : handlerMethods) {
                            ((ApplicationEventDispatcher)dispatcherProvider.get()).registerListener(injectee, handlerMethod, handlerMethod.getParameterTypes()[0]);
                        }
                    }
                });
            }
        }

        private List<Method> getAllDeclaredHandlerMethods(Class<?> clazz) {
            ArrayList<Method> handlerMethods = new ArrayList<Method>();
            while (clazz != null && !Collection.class.isAssignableFrom(clazz) && !clazz.isArray()) {
                for (Method handlerMethod : clazz.getDeclaredMethods()) {
                    if (!handlerMethod.isAnnotationPresent(EventListener.class)) continue;
                    if (handlerMethod.getReturnType().equals(Void.TYPE) && handlerMethod.getParameterTypes().length == 1 && ApplicationEvent.class.isAssignableFrom(handlerMethod.getParameterTypes()[0])) {
                        handlerMethods.add(handlerMethod);
                        continue;
                    }
                    throw new IllegalArgumentException("@EventListener " + clazz.getName() + "." + handlerMethod.getName() + "skipped. Methods must be public, void, and accept exactly one argument extending com.netflix.governator.event.ApplicationEvent.");
                }
                clazz = clazz.getSuperclass();
            }
            return handlerMethods;
        }
    }
}

