/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.event.guava;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.reflect.TypeToken;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.netflix.governator.event.ApplicationEvent;
import com.netflix.governator.event.ApplicationEventDispatcher;
import com.netflix.governator.event.ApplicationEventListener;
import com.netflix.governator.event.ApplicationEventModule;
import com.netflix.governator.event.ApplicationEventRegistration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.inject.Inject;

public final class GuavaApplicationEventModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new ApplicationEventModule());
        this.bind(ApplicationEventDispatcher.class).to(GuavaApplicationEventDispatcher.class).asEagerSingleton();
    }

    public boolean equals(Object obj) {
        return ((Object)((Object)this)).getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    public String toString() {
        return "GuavaApplicationEventModule[]";
    }

    private static final class GuavaApplicationEventDispatcher
    implements ApplicationEventDispatcher {
        private final EventBus eventBus;
        private final Method eventListenerMethod;

        @Inject
        public GuavaApplicationEventDispatcher(EventBus eventBus) {
            this.eventBus = eventBus;
            try {
                this.eventListenerMethod = ApplicationEventListener.class.getDeclaredMethod("onEvent", ApplicationEvent.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to cache ApplicationEventListener method", e);
            }
        }

        public ApplicationEventRegistration registerListener(Object instance, Method method, Class<? extends ApplicationEvent> eventType) {
            GuavaSubscriberProxy proxy = new GuavaSubscriberProxy(instance, method, eventType);
            this.eventBus.register((Object)proxy);
            return new GuavaEventRegistration(this.eventBus, proxy);
        }

        public <T extends ApplicationEvent> ApplicationEventRegistration registerListener(Class<T> eventType, ApplicationEventListener<T> eventListener) {
            GuavaSubscriberProxy proxy = new GuavaSubscriberProxy(eventListener, this.eventListenerMethod, eventType);
            this.eventBus.register((Object)proxy);
            return new GuavaEventRegistration(this.eventBus, proxy);
        }

        public ApplicationEventRegistration registerListener(ApplicationEventListener<? extends ApplicationEvent> eventListener) {
            Type[] genericInterfaces;
            for (Type type : genericInterfaces = eventListener.getClass().getGenericInterfaces()) {
                if (!ApplicationEventListener.class.isAssignableFrom(TypeToken.of((Type)type).getRawType())) continue;
                ParameterizedType ptype = (ParameterizedType)type;
                Class rawType = TypeToken.of((Type)ptype.getActualTypeArguments()[0]).getRawType();
                GuavaSubscriberProxy proxy = new GuavaSubscriberProxy(eventListener, this.eventListenerMethod, rawType);
                this.eventBus.register((Object)proxy);
                return new GuavaEventRegistration(this.eventBus, proxy);
            }
            return new ApplicationEventRegistration(){

                public void unregister() {
                }
            };
        }

        public void publishEvent(ApplicationEvent event) {
            this.eventBus.post((Object)event);
        }

        private static class GuavaEventRegistration
        implements ApplicationEventRegistration {
            private final EventBus eventBus;
            private final GuavaSubscriberProxy subscriber;

            public GuavaEventRegistration(EventBus eventBus, GuavaSubscriberProxy subscriber) {
                this.eventBus = eventBus;
                this.subscriber = subscriber;
            }

            public void unregister() {
                this.eventBus.unregister((Object)this.subscriber);
            }
        }

        private static class GuavaSubscriberProxy {
            private final Object handlerInstance;
            private final Method handlerMethod;
            private final Class<?> acceptedType;

            public GuavaSubscriberProxy(Object handlerInstance, Method handlerMethod, Class<?> acceptedType) {
                this.handlerInstance = handlerInstance;
                this.handlerMethod = handlerMethod;
                this.acceptedType = acceptedType;
            }

            @Subscribe
            public void invokeEventHandler(ApplicationEvent event) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
                if (this.acceptedType.isAssignableFrom(event.getClass())) {
                    if (!this.handlerMethod.isAccessible()) {
                        this.handlerMethod.setAccessible(true);
                    }
                    this.handlerMethod.invoke(this.handlerInstance, event);
                }
            }
        }
    }
}

