/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.internal;

import com.google.common.base.Supplier;
import com.netflix.governator.LifecycleAction;
import com.netflix.governator.LifecycleFeature;
import com.netflix.governator.internal.JSR250LifecycleAction;
import com.netflix.governator.internal.TypeInspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PostConstructLifecycleFeature
implements LifecycleFeature {
    private static final Logger LOG = LoggerFactory.getLogger(PostConstructLifecycleFeature.class);
    private final JSR250LifecycleAction.ValidationMode validationMode;

    public PostConstructLifecycleFeature(JSR250LifecycleAction.ValidationMode validationMode) {
        this.validationMode = validationMode;
    }

    @Override
    public List<LifecycleAction> getActionsForType(Class<?> type) {
        return (List)TypeInspector.accept(type, new PostConstructVisitor());
    }

    public String toString() {
        return "PostConstruct";
    }

    private class PostConstructVisitor
    implements TypeInspector.TypeVisitor,
    Supplier<List<LifecycleAction>> {
        private final Set<String> visitContext = new HashSet<String>();
        private final LinkedList<LifecycleAction> typeActions = new LinkedList();

        @Override
        public boolean visit(Class<?> clazz) {
            return !clazz.isInterface();
        }

        @Override
        public boolean visit(Method method) {
            String methodName = method.getName();
            if (method.isAnnotationPresent(PostConstruct.class)) {
                if (!this.visitContext.contains(methodName)) {
                    try {
                        JSR250LifecycleAction postConstructAction = new JSR250LifecycleAction(PostConstruct.class, method, PostConstructLifecycleFeature.this.validationMode);
                        LOG.debug("adding action {}", (Object)postConstructAction);
                        this.typeActions.addFirst(postConstructAction);
                        this.visitContext.add(methodName);
                    }
                    catch (IllegalArgumentException e) {
                        LOG.info("ignoring @PostConstruct method {}.{}() - {}", new Object[]{method.getDeclaringClass().getName(), methodName, e.getMessage()});
                    }
                }
            } else if (method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 0 && !Modifier.isFinal(method.getModifiers())) {
                this.visitContext.add(methodName);
            }
            return true;
        }

        @Override
        public boolean visit(Field field) {
            return true;
        }

        public List<LifecycleAction> get() {
            return Collections.unmodifiableList(this.typeActions);
        }
    }
}

