/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.internal;

import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Binding;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scope;
import com.google.inject.Scopes;
import com.google.inject.spi.BindingScopingVisitor;
import com.google.inject.spi.DefaultBindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.util.Providers;
import com.netflix.governator.LifecycleAction;
import com.netflix.governator.ManagedInstanceAction;
import com.netflix.governator.internal.AbstractScope;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreDestroyMonitor
implements AutoCloseable {
    private static Logger LOGGER = LoggerFactory.getLogger(PreDestroyMonitor.class);
    private ConcurrentMap<Object, UnscopedCleanupAction> cleanupActions = new MapMaker().weakKeys().concurrencyLevel(256).makeMap();
    private ScopeCleaner scopeCleaner = new ScopeCleaner();
    private Map<Class<? extends Annotation>, Scope> scopeBindings;

    public PreDestroyMonitor(Map<Class<? extends Annotation>, Scope> scopeBindings) {
        this.scopeBindings = new HashMap<Class<? extends Annotation>, Scope>(scopeBindings);
    }

    public <T> boolean register(T destroyableInstance, Binding<T> binding, Iterable<LifecycleAction> action) {
        if (this.scopeCleaner.isRunning()) {
            boolean visitNoScope = (Boolean)Optional.ofNullable(binding.acceptTargetVisitor(new ProviderInstanceBindingVisitor())).orElse(true);
            return (Boolean)binding.acceptScopingVisitor((BindingScopingVisitor)new ManagedInstanceScopingVisitor(destroyableInstance, binding.getSource(), action, visitNoScope));
        }
        return false;
    }

    public <T> boolean register(T destroyableInstance, Object context, Iterable<LifecycleAction> action) {
        return this.scopeCleaner.isRunning() ? new ManagedInstanceScopingVisitor(destroyableInstance, context, action).visitEagerSingleton() : false;
    }

    public void addScopeBindings(Map<Class<? extends Annotation>, Scope> bindings) {
        if (this.scopeCleaner.isRunning()) {
            this.scopeBindings.putAll(bindings);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.scopeCleaner.close()) {
            LOGGER.info("closing PreDestroyMonitor...");
            ArrayList actions = new ArrayList(this.cleanupActions.entrySet());
            if (actions.size() > 0) {
                LOGGER.warn("invoking predestroy action for {} unscoped instances", (Object)actions.size());
                actions.stream().map(Map.Entry::getValue).collect(Collectors.groupingBy(UnscopedCleanupAction::getContext, Collectors.counting())).forEach((source, count) -> LOGGER.warn("  including {} objects from source '{}'", count, source));
            }
            actions.stream().sorted(Map.Entry.comparingByValue()).forEach(action -> Optional.ofNullable(action.getKey()).ifPresent(obj -> ((UnscopedCleanupAction)action.getValue()).call(obj)));
            actions.clear();
            this.cleanupActions.clear();
            this.scopeBindings.clear();
            this.scopeBindings = Collections.emptyMap();
        } else {
            LOGGER.warn("PreDestroyMonitor.close() invoked but instance is not running");
        }
    }

    private static class ProviderInstanceBindingVisitor<T>
    extends DefaultBindingTargetVisitor<T, Boolean> {
        private ProviderInstanceBindingVisitor() {
        }

        public Boolean visit(ProviderInstanceBinding<? extends T> providerInstanceBinding) {
            Dependency parentDep;
            Set bindingDependencies = providerInstanceBinding.getDependencies();
            if (bindingDependencies.size() == 1 && (parentDep = (Dependency)bindingDependencies.iterator().next()).getParameterIndex() == -1 && parentDep.getKey().getTypeLiteral().equals((Object)providerInstanceBinding.getKey().getTypeLiteral())) {
                return false;
            }
            return true;
        }
    }

    private static final class ScopeCleanupAction
    extends WeakReference<ScopeCleanupMarker>
    implements Callable<Void>,
    Comparable<ScopeCleanupAction> {
        private static volatile long instanceCounter = 0L;
        private final Object id;
        private final long ordinal;
        private Deque<Object[]> delegates = new ConcurrentLinkedDeque<Object[]>();
        private final AtomicBoolean complete = new AtomicBoolean(false);

        public ScopeCleanupAction(ScopeCleanupMarker marker, ReferenceQueue<ScopeCleanupMarker> refQueue) {
            super(marker, refQueue);
            this.id = marker.getId();
            this.ordinal = instanceCounter++;
        }

        public Object getId() {
            return this.id;
        }

        public void add(Provider<ScopeCleanupMarker> scopeProvider, Callable<Void> action) {
            if (!this.complete.get()) {
                this.delegates.addFirst(new Object[]{action, scopeProvider});
            }
        }

        @Override
        public Void call() {
            if (this.complete.compareAndSet(false, true) && this.delegates != null) {
                for (Object[] r : this.delegates) {
                    try {
                        ((Callable)r[0]).call();
                    }
                    catch (Exception e) {
                        LOGGER.error("PreDestroy call failed for " + r, (Throwable)e);
                    }
                }
                this.delegates.clear();
                this.clear();
            }
            return null;
        }

        @Override
        public int compareTo(ScopeCleanupAction o) {
            return Long.compare(this.ordinal, o.ordinal);
        }
    }

    private static final class UnscopedCleanupAction
    implements LifecycleAction,
    Comparable<UnscopedCleanupAction> {
        private static volatile long instanceCounter = 0L;
        private final long ordinal;
        private final Object context;
        private final Iterable<LifecycleAction> lifecycleActions;

        public UnscopedCleanupAction(Object context, Iterable<LifecycleAction> lifecycleActions) {
            this.context = context;
            this.lifecycleActions = lifecycleActions;
            this.ordinal = instanceCounter++;
        }

        @Override
        public void call(Object obj) {
            this.lifecycleActions.forEach(action -> {
                try {
                    action.call(obj);
                }
                catch (Exception e) {
                    LOGGER.error("PreDestroy call failed for {} from {}", new Object[]{action, this.context, e});
                }
            });
        }

        @Override
        public int compareTo(UnscopedCleanupAction o) {
            return Long.compare(o.ordinal, this.ordinal);
        }

        public Object getContext() {
            return this.context;
        }
    }

    private final class ManagedInstanceScopingVisitor
    implements BindingScopingVisitor<Boolean> {
        private final Object injectee;
        private final Object context;
        private final Iterable<LifecycleAction> lifecycleActions;
        private final boolean processNoScope;

        private ManagedInstanceScopingVisitor(Object injectee, Object context, Iterable<LifecycleAction> lifecycleActions) {
            this(injectee, context, lifecycleActions, true);
        }

        private ManagedInstanceScopingVisitor(Object injectee, Object context, Iterable<LifecycleAction> lifecycleActions, boolean processNoScope) {
            this.injectee = injectee;
            this.context = context;
            this.lifecycleActions = lifecycleActions;
            this.processNoScope = processNoScope;
        }

        public Boolean visitEagerSingleton() {
            return this.visitScope(Scopes.SINGLETON);
        }

        public Boolean visitScope(Scope scope) {
            Provider scopedMarkerProvider;
            if (scope.equals(Scopes.SINGLETON) || scope instanceof AbstractScope && ((AbstractScope)scope).isSingletonScope()) {
                scopedMarkerProvider = Providers.of((Object)((PreDestroyMonitor)PreDestroyMonitor.this).scopeCleaner.singletonMarker);
            } else {
                if (scope.equals(Scopes.NO_SCOPE)) {
                    return this.visitNoScoping();
                }
                scopedMarkerProvider = scope.scope(ScopeCleanupMarker.MARKER_KEY, (Provider)PreDestroyMonitor.this.scopeCleaner);
            }
            ScopeCleanupMarker marker = (ScopeCleanupMarker)scopedMarkerProvider.get();
            marker.getCleanupAction().add((Provider<ScopeCleanupMarker>)scopedMarkerProvider, new ManagedInstanceAction(this.injectee, this.lifecycleActions));
            return true;
        }

        public Boolean visitScopeAnnotation(Class<? extends Annotation> scopeAnnotation) {
            boolean rv;
            Scope scope = (Scope)PreDestroyMonitor.this.scopeBindings.get(scopeAnnotation);
            if (scope != null) {
                rv = this.visitScope(scope);
            } else {
                LOGGER.warn("no scope binding found for annotation " + scopeAnnotation.getName());
                rv = false;
            }
            return rv;
        }

        public Boolean visitNoScoping() {
            if (this.processNoScope) {
                PreDestroyMonitor.this.cleanupActions.computeIfAbsent(this.injectee, i -> {
                    LOGGER.debug("predestroy action registered for unscoped instance {} from {}", i, this.context);
                    return new UnscopedCleanupAction(this.context, this.lifecycleActions);
                });
            }
            return true;
        }
    }

    static final class ScopeCleaner
    implements Provider<ScopeCleanupMarker> {
        ConcurrentMap<Object, ScopeCleanupAction> scopedCleanupActions = new ConcurrentHashMap<Object, ScopeCleanupAction>(16384);
        ReferenceQueue<ScopeCleanupMarker> markerReferenceQueue = new ReferenceQueue();
        final ExecutorService reqQueueExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("predestroy-monitor-%d").build());
        final AtomicBoolean running = new AtomicBoolean(true);
        final ScopeCleanupMarker singletonMarker = this.get();

        ScopeCleaner() {
            this.reqQueueExecutor.submit(new ScopedCleanupWorker());
        }

        public ScopeCleanupMarker get() {
            ScopeCleanupMarker marker = new ScopeCleanupMarker(this.markerReferenceQueue);
            this.scopedCleanupActions.put(marker.getId(), marker.getCleanupAction());
            return marker;
        }

        public boolean isRunning() {
            return this.running.get();
        }

        public boolean close() throws Exception {
            boolean rv = this.running.compareAndSet(true, false);
            if (rv) {
                this.reqQueueExecutor.shutdown();
                ArrayList values = new ArrayList(this.scopedCleanupActions.values());
                this.scopedCleanupActions.clear();
                Collections.sort(values);
                for (Callable actions : values) {
                    actions.call();
                }
                if (!this.reqQueueExecutor.awaitTermination(90L, TimeUnit.SECONDS)) {
                    LOGGER.error("internal executor still active; shutting down now");
                    this.reqQueueExecutor.shutdownNow();
                }
                this.markerReferenceQueue = null;
            }
            return rv;
        }

        final class ScopedCleanupWorker
        implements Runnable {
            ScopedCleanupWorker() {
            }

            @Override
            public void run() {
                try {
                    while (ScopeCleaner.this.running.get()) {
                        Object markerKey;
                        ScopeCleanupAction cleanupAction;
                        Reference<ScopeCleanupMarker> ref = ScopeCleaner.this.markerReferenceQueue.remove(1000L);
                        if (ref == null || !(ref instanceof ScopeCleanupAction) || (cleanupAction = (ScopeCleanupAction)ScopeCleaner.this.scopedCleanupActions.remove(markerKey = ((ScopeCleanupAction)ref).getId())) == null) continue;
                        cleanupAction.call();
                    }
                    LOGGER.info("PreDestroyMonitor.ScopedCleanupWorker is exiting");
                }
                catch (InterruptedException e) {
                    LOGGER.info("PreDestroyMonitor.ScopedCleanupWorker is exiting due to thread interrupt");
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private static class ScopeCleanupMarker {
        static final Key<ScopeCleanupMarker> MARKER_KEY = Key.get(ScopeCleanupMarker.class);
        private final Object id = new Object();
        private final ScopeCleanupAction cleanupAction;

        public ScopeCleanupMarker(ReferenceQueue<ScopeCleanupMarker> markerReferenceQueue) {
            this.cleanupAction = new ScopeCleanupAction(this, markerReferenceQueue);
        }

        Object getId() {
            return this.id;
        }

        public ScopeCleanupAction getCleanupAction() {
            return this.cleanupAction;
        }
    }
}

