/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.governator.test;

import com.google.common.base.Strings;
import com.google.inject.spi.ProvisionListener;
import java.io.PrintStream;

public class TracingProvisionListener
implements ProvisionListener {
    private int indent = 0;
    private final String prefix;
    private final int indentAmount;
    private final BindingFormatter beforeFormatter;
    private final BindingFormatter afterFormatter;
    private final PrintStream stream;
    private ErrorFormatter errorFormatter;
    private static final BindingFormatter EMPTY_BINDING_FORMATTER = new BindingFormatter(){

        @Override
        public <T> String format(ProvisionListener.ProvisionInvocation<T> provision) {
            return "";
        }
    };
    private static final BindingFormatter SIMPLE_BINDING_FORMATTER = new BindingFormatter(){

        @Override
        public <T> String format(ProvisionListener.ProvisionInvocation<T> provision) {
            return provision.getBinding().getKey().toString();
        }
    };
    private static final ErrorFormatter SIMPLE_ERROR_FORMATTER = new ErrorFormatter(){

        @Override
        public <T> String format(ProvisionListener.ProvisionInvocation<T> provision, Throwable t) {
            return String.format("Error creating '%s'. %s", provision.getBinding().getKey().toString(), t.getMessage());
        }
    };

    public static TracingProvisionListener createDefault() {
        return new TracingProvisionListener(TracingProvisionListener.newBuilder());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private TracingProvisionListener(Builder builder) {
        this.indentAmount = builder.indentAmount;
        this.beforeFormatter = builder.beforeFormatter;
        this.afterFormatter = builder.afterFormatter;
        this.errorFormatter = builder.errorFormatter;
        this.prefix = builder.prefix;
        this.stream = builder.stream;
    }

    public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> provision) {
        this.writeString(this.beforeFormatter.format(provision));
        this.indent += this.indentAmount;
        try {
            provision.provision();
            this.writeString(this.afterFormatter.format(provision));
        }
        catch (Throwable t) {
            this.writeString(this.errorFormatter.format(provision, t));
            throw t;
        }
        finally {
            this.indent -= this.indentAmount;
        }
    }

    private void writeString(String str) {
        if (str != null && !str.isEmpty()) {
            this.stream.println(this.prefix + Strings.repeat((String)" ", (int)this.indent) + str);
        }
    }

    static /* synthetic */ BindingFormatter access$000() {
        return SIMPLE_BINDING_FORMATTER;
    }

    static /* synthetic */ BindingFormatter access$100() {
        return EMPTY_BINDING_FORMATTER;
    }

    static /* synthetic */ ErrorFormatter access$200() {
        return SIMPLE_ERROR_FORMATTER;
    }

    public static interface ErrorFormatter {
        public <T> String format(ProvisionListener.ProvisionInvocation<T> var1, Throwable var2);
    }

    public static interface BindingFormatter {
        public <T> String format(ProvisionListener.ProvisionInvocation<T> var1);
    }

    public static class Builder {
        private String prefix = "";
        private int indentAmount = 2;
        private BindingFormatter beforeFormatter = TracingProvisionListener.access$000();
        private BindingFormatter afterFormatter = TracingProvisionListener.access$100();
        private ErrorFormatter errorFormatter = TracingProvisionListener.access$200();
        private PrintStream stream = System.out;

        public Builder formatBeforeWith(BindingFormatter formatter) {
            this.beforeFormatter = formatter;
            return this;
        }

        public Builder formatAfterWith(BindingFormatter formatter) {
            this.afterFormatter = formatter;
            return this;
        }

        public Builder formatErrorsWith(ErrorFormatter formatter) {
            this.errorFormatter = formatter;
            return this;
        }

        public Builder indentBy(int amount) {
            this.indentAmount = amount;
            return this;
        }

        public Builder writeTo(PrintStream stream) {
            this.stream = stream;
            return this;
        }

        public Builder prefixLinesWith(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public TracingProvisionListener build() {
            return new TracingProvisionListener(this);
        }
    }
}

