/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.cli;

import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.security.fips.FipsValidator;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Exit;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.connect.connector.policy.ConnectorClientConfigOverridePolicy;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.Connect;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.apache.kafka.connect.runtime.WorkerInfo;
import org.apache.kafka.connect.runtime.isolation.Plugins;
import org.apache.kafka.connect.runtime.rest.ConnectRestServer;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestServer;
import org.apache.kafka.connect.util.ConnectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectCli<H extends Herder, T extends WorkerConfig> {
    private static final String CONFLUENT_LICENSE_MANAGER_CLASS = "io.confluent.license.LicenseManager";
    private static final Logger log = LoggerFactory.getLogger(AbstractConnectCli.class);
    private final String[] args;
    private final Time time = Time.SYSTEM;

    protected AbstractConnectCli(String ... args) {
        this.args = args;
    }

    protected abstract String usage();

    public void processExtraArgs(Connect<H> connect, String[] extraArgs) {
    }

    protected abstract H createHerder(T var1, String var2, Plugins var3, ConnectorClientConfigOverridePolicy var4, RestServer var5, RestClient var6);

    protected abstract T createConfig(Map<String, String> var1);

    public void run() {
        if (this.args.length < 1 || Arrays.asList(this.args).contains("--help")) {
            log.info("Usage: {}", (Object)this.usage());
            Exit.exit((int)1);
        }
        try {
            String workerPropsFile = this.args[0];
            Map workerProps = !workerPropsFile.isEmpty() ? Utils.propsToStringMap((Properties)Utils.loadProps((String)workerPropsFile)) : Collections.emptyMap();
            String[] extraArgs = Arrays.copyOfRange(this.args, 1, this.args.length);
            Connect<H> connect = this.startConnect(workerProps);
            this.processExtraArgs(connect, extraArgs);
            connect.awaitStop();
        }
        catch (Throwable t) {
            log.error("Stopping due to error", t);
            Exit.exit((int)2);
        }
    }

    public Connect<H> startConnect(Map<String, String> workerProps) {
        log.info("Kafka Connect worker initializing ...");
        long initStart = this.time.hiResClockMs();
        WorkerInfo initInfo = new WorkerInfo();
        initInfo.logAll();
        this.verifyLicenseManagerAvailability();
        log.info("Scanning for plugin classes. This might take a moment ...");
        Plugins plugins = new Plugins(workerProps);
        plugins.compareAndSwapWithDelegatingLoader();
        SecurityUtils.addConfiguredSecurityProviders(workerProps);
        T config = this.createConfig(workerProps);
        log.debug("Kafka cluster ID: {}", (Object)((WorkerConfig)((Object)config)).kafkaClusterId());
        if (config.getBoolean("enable.fips").booleanValue()) {
            FipsValidator fipsValidator = ConfluentConfigs.buildFipsValidator();
            String brokerSecurityProtocol = config.getString("security.protocol");
            HashMap<String, SecurityProtocol> securityProtocolMap = new HashMap<String, SecurityProtocol>();
            securityProtocolMap.put(brokerSecurityProtocol, SecurityProtocol.forName((String)brokerSecurityProtocol));
            String advertisedProtocol = ConnectUtils.determineAdvertisedProtocol(config);
            fipsValidator.validateFipsTls(config.valuesWithPrefixAllOrNothing("listeners.https."));
            fipsValidator.validateFipsBrokerProtocol(securityProtocolMap);
            fipsValidator.validateRestProtocol(advertisedProtocol);
        }
        log.info("FIPS mode enabled in connect: ${config.fipsEnabled}");
        SecurityUtils.addConfiguredSSLProvider(config);
        RestClient restClient = new RestClient((AbstractConfig)config);
        ConnectRestServer restServer = new ConnectRestServer(((WorkerConfig)((Object)config)).rebalanceTimeout(), restClient, ((WorkerConfig)((Object)config)).originals());
        restServer.initializeServer();
        URI advertisedUrl = restServer.advertisedUrl();
        String workerId = advertisedUrl.getHost() + ":" + advertisedUrl.getPort();
        ConnectorClientConfigOverridePolicy connectorClientConfigOverridePolicy = plugins.newPlugin(config.getString("connector.client.config.override.policy"), (AbstractConfig)config, ConnectorClientConfigOverridePolicy.class);
        H herder = this.createHerder(config, workerId, plugins, connectorClientConfigOverridePolicy, restServer, restClient);
        Connect<H> connect = new Connect<H>(herder, restServer);
        log.info("Kafka Connect worker initialization took {}ms", (Object)(this.time.hiResClockMs() - initStart));
        try {
            connect.start();
        }
        catch (Exception e) {
            log.error("Failed to start Connect", (Throwable)e);
            connect.stop();
            Exit.exit((int)3);
        }
        return connect;
    }

    void verifyLicenseManagerAvailability() {
        try {
            Class<?> licenseManagerClass = Class.forName(CONFLUENT_LICENSE_MANAGER_CLASS, false, Thread.currentThread().getContextClassLoader());
            String jarLocation = this.getJarLocation(licenseManagerClass);
            this.verifyLicenseManagerMethod(licenseManagerClass, jarLocation);
            this.verifyCommandEnumValue(jarLocation);
        }
        catch (ClassNotFoundException e) {
            log.error("Failed to load LicenseManager class. This indicates that the Confluent license library is not available.", (Throwable)e);
            throw new ConnectException("LicenseManager class not found. Ensure the Confluent license library is in the classpath.", (Throwable)e);
        }
    }

    protected String getJarLocation(Class<?> clazz) {
        try {
            URL location = clazz.getProtectionDomain().getCodeSource().getLocation();
            return location != null ? location.toString() : "unknown location";
        }
        catch (Exception e) {
            return "unknown location";
        }
    }

    protected void verifyLicenseManagerMethod(Class<?> licenseManagerClass, String jarLocation) {
        try {
            licenseManagerClass.getMethod("registerOrValidateMultiLicense", String.class, Boolean.TYPE);
            log.debug("Found required method: registerOrValidateMultiLicense");
        }
        catch (NoSuchMethodException e) {
            throw new ConnectException("Incompatible license library version detected. The license library loaded from [" + jarLocation + "] is outdated and missing required functionality. This typically happens when an older version of Confluent Platform libraries is present in the classpath. To resolve: Remove the incompatible JAR from the classpath and ensure only libraries from Confluent Platform " + AppInfoParser.getVersion() + " or later are present.");
        }
    }

    private void verifyCommandEnumValue(String licenseJarLocation) {
        try {
            Class<?> commandConfigType = Class.forName("io.confluent.command.record.Command$CommandConfigType", false, Thread.currentThread().getContextClassLoader());
            String commandJarLocation = this.getJarLocation(commandConfigType);
            if (!commandConfigType.isEnum() || Arrays.stream(commandConfigType.getEnumConstants()).map(Object::toString).noneMatch("CP_FOR_CC_LICENSE_INFO"::equals)) {
                throw new ConnectException("Incompatible serialization library version detected. The library loaded from [" + commandJarLocation + "] is outdated and missing required license support. This typically happens when an older version of Confluent Platform libraries is present in the classpath. To resolve: Remove the incompatible JAR from the classpath and ensure only libraries from Confluent Platform " + AppInfoParser.getVersion() + " or later are present.");
            }
            log.debug("Found required enum value: CP_FOR_CC_LICENSE_INFO");
        }
        catch (ClassNotFoundException e) {
            throw new ConnectException("Required Confluent Platform libraries are missing or incompatible. The license library was found at [" + licenseJarLocation + "] but related components are missing. This typically indicates an incomplete or mixed version installation. To resolve: Ensure you have a complete installation of Confluent Platform " + AppInfoParser.getVersion() + " or later and remove any older version libraries from the classpath.");
        }
    }
}

