/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.events;

import java.util.Collections;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.kafka.common.network.ConnectionMode;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.DefaultSslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectMetadataSslFactory {
    private static final Logger log = LoggerFactory.getLogger(ConnectMetadataSslFactory.class);
    private final SslFactory sslFactory;
    private final Map<String, Object> sslConfigs;

    public ConnectMetadataSslFactory(Map<String, Object> sslConfigs) {
        this.sslConfigs = sslConfigs;
        this.sslFactory = new SslFactory(ConnectionMode.CLIENT);
        try {
            log.debug("Configuring SSL factory with {} SSL properties", (Object)sslConfigs.size());
            this.sslFactory.configure(sslConfigs);
            log.debug("SSL factory configured successfully");
        }
        catch (Exception e) {
            log.error("Failed to configure SSL factory", (Throwable)e);
            throw new ConnectException("SSL configuration failed", (Throwable)e);
        }
    }

    public boolean isSslConfigured() {
        return this.sslFactory.sslEngineFactory() != null;
    }

    public SSLSocketFactory getSslSocketFactory() {
        if (!this.isSslConfigured()) {
            return null;
        }
        try {
            DefaultSslEngineFactory sslEngineFactory = DefaultSslEngineFactory.castOrThrow((SslEngineFactory)this.sslFactory.sslEngineFactory());
            SSLContext sslContext = sslEngineFactory.sslContext();
            log.debug("SSL socket factory created successfully");
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            log.error("Failed to create SSL socket factory", (Throwable)e);
            return null;
        }
    }

    public X509TrustManager getTrustManager() {
        if (!this.isSslConfigured()) {
            return null;
        }
        try {
            DefaultSslEngineFactory sslEngineFactory = DefaultSslEngineFactory.castOrThrow((SslEngineFactory)this.sslFactory.sslEngineFactory());
            TrustManager[] trustManagers = DefaultSslEngineFactory.trustManagers((SslEngineFactory)sslEngineFactory);
            if (trustManagers != null && trustManagers.length > 0 && trustManagers[0] instanceof X509TrustManager) {
                log.debug("X509 trust manager retrieved successfully");
                return (X509TrustManager)trustManagers[0];
            }
            log.debug("No X509 trust manager available (using JVM default)");
            return null;
        }
        catch (Exception e) {
            log.error("Failed to get trust manager", (Throwable)e);
            return null;
        }
    }

    public void close() {
        if (this.sslFactory != null) {
            try {
                this.sslFactory.close();
                log.debug("SSL factory closed successfully");
            }
            catch (Exception e) {
                log.warn("Error closing SSL factory", (Throwable)e);
            }
        }
    }

    public Map<String, Object> getSslConfigs() {
        return Collections.unmodifiableMap(this.sslConfigs);
    }
}

