/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime.rest.resources;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import java.util.HashMap;
import org.apache.kafka.connect.runtime.Herder;
import org.apache.kafka.connect.runtime.rest.HerderRequestHandler;
import org.apache.kafka.connect.runtime.rest.RestClient;
import org.apache.kafka.connect.runtime.rest.RestRequestTimeout;
import org.apache.kafka.connect.util.FutureCallback;

@Path(value="/cluster")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class ClusterResource {
    private final Herder herder;
    private final HerderRequestHandler requestHandler;
    private final RestRequestTimeout requestTimeout;

    @Inject
    public ClusterResource(Herder herder, RestClient restClient, RestRequestTimeout requestTimeout) {
        this.herder = herder;
        this.requestTimeout = requestTimeout;
        this.requestHandler = new HerderRequestHandler(restClient, requestTimeout);
    }

    @PUT
    @Path(value="/rebalance")
    @Operation(summary="Trigger a rebalance on a Connect Cluster. If preemptScheduledRebalance is set to true, then the rebalance would not wait for any departed workers to come back if scheduled rebalance is active and instead reassign their assignments immediately.")
    public void rebalance(@Context HttpHeaders headers, @DefaultValue(value="false") @QueryParam(value="preemptScheduledRebalance") @Parameter(description="Preempt any active Scheduled rebalance delay") Boolean preemptScheduledRebalance, @Parameter(hidden=true) @QueryParam(value="forward") Boolean forward) throws Throwable {
        FutureCallback<Void> cb = new FutureCallback<Void>();
        this.herder.triggerRebalance(preemptScheduledRebalance, cb);
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        queryParameters.put("preemptScheduledRebalance", preemptScheduledRebalance.toString());
        String forwardingPath = "/cluster/rebalance";
        this.requestHandler.completeOrForwardRequest(cb, forwardingPath, "PUT", headers, queryParameters, null, null, new HerderRequestHandler.IdentityTranslator(), forward);
    }
}

