/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.common.utils;

import java.lang.ref.WeakReference;
import java.util.WeakHashMap;

public final class Interner<T> {
    private final WeakHashMap<T, WeakReference<T>> refs = new WeakHashMap();

    public synchronized T intern(T item) {
        T interned = this.get(item);
        if (interned != null) {
            return interned;
        }
        this.put(item);
        return item;
    }

    private T get(T item) {
        WeakReference<T> weakRef = this.refs.get(item);
        if (weakRef == null) {
            return null;
        }
        return weakRef.get();
    }

    private void put(T item) {
        this.refs.put(item, new WeakReference<T>(item));
    }
}

