/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

import io.confluent.kafka.server.plugins.auth.PbkdfBase64;

public class DeconstructedPbkdf2Hash {
    private static final int MIN_COST = 60;
    private static final int MAX_COST = 99;
    private static final char CURRENT_VERSION = '1';
    private static final int SALT_SIZE = 16;
    private static final int ENCODED_SALT_SIZE = DeconstructedPbkdf2Hash.calculateEncodedLen(16);
    private static final int DERIVED_KEY_SIZE = 23;
    private static final int ENCODED_DERIVED_KEY_SIZE = DeconstructedPbkdf2Hash.calculateEncodedLen(23);
    private static final int HASH_SIZE = 60;
    private int cost;
    private char version;
    private String salt;
    private String derivedKey;

    private static int calculateEncodedLen(int size) {
        return PbkdfBase64.encode(new byte[size], size).length();
    }

    public void fromHashedSecret(String hs) throws Exception {
        StringBuilder hashedSecret = new StringBuilder(hs);
        if (hashedSecret.length() != 60) {
            throw new Exception("Invalid hash length");
        }
        int n = this.decodeVersion(hashedSecret, 0);
        n = this.decodeCost(hashedSecret, n);
        this.salt = hashedSecret.substring(n, n + ENCODED_SALT_SIZE);
        this.derivedKey = hashedSecret.substring(n += ENCODED_SALT_SIZE, n + ENCODED_DERIVED_KEY_SIZE);
    }

    private int decodeVersion(StringBuilder sbytes, int offset) throws Exception {
        if (sbytes.charAt(offset) != '$') {
            throw new Exception("Invalid hash prefix");
        }
        if (sbytes.charAt(offset + 1) != 'v' || sbytes.charAt(offset + 2) != '1') {
            throw new Exception("Invalid hash version");
        }
        if (sbytes.charAt(offset + 3) != '$') {
            throw new Exception("Invalid hash format");
        }
        this.version = sbytes.charAt(offset + 2);
        return offset + 4;
    }

    private int decodeCost(StringBuilder sbytes, int offset) throws Exception {
        String costString = sbytes.substring(offset + 0, offset + 2);
        int cost = Integer.parseInt(costString);
        if (cost < 60 || cost > 99) {
            throw new Exception("Invalid cost");
        }
        if (sbytes.charAt(offset + 2) != '$') {
            throw new Exception("Invalid hash format");
        }
        this.cost = cost;
        return offset + 3;
    }

    public int cost() {
        return this.cost;
    }

    public String salt() {
        return this.salt;
    }

    public String derivedKey() {
        return this.derivedKey;
    }
}

