/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.util;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.ClientRequest;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.RequestCompletionHandler;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.DisconnectException;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.RequestAndCompletionHandler;
import org.apache.kafka.server.util.ShutdownableThread;

public abstract class InterBrokerSendThread
extends ShutdownableThread {
    public final UnsentRequests unsentRequests;
    protected final KafkaClient networkClient;
    private final int requestTimeoutMs;
    private final Time time;

    protected InterBrokerSendThread(String name, KafkaClient networkClient, int requestTimeoutMs, Time time) {
        this(name, networkClient, requestTimeoutMs, time, true);
    }

    protected InterBrokerSendThread(String name, KafkaClient networkClient, int requestTimeoutMs, Time time, boolean isInterruptible) {
        super(name, isInterruptible);
        this.networkClient = networkClient;
        this.requestTimeoutMs = requestTimeoutMs;
        this.time = time;
        this.unsentRequests = new UnsentRequests();
    }

    public abstract Collection<RequestAndCompletionHandler> generateRequests();

    public boolean hasUnsentRequests() {
        return this.unsentRequests.iterator().hasNext();
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.initiateShutdown();
        this.networkClient.initiateClose();
        this.awaitShutdown();
        Utils.closeQuietly((AutoCloseable)this.networkClient, (String)"InterBrokerSendThread network client");
    }

    private void drainGeneratedRequests() {
        this.generateRequests().forEach(request -> this.unsentRequests.put(request.destination, this.networkClient.newClientRequest(request.destination.idString(), request.request, request.creationTimeMs, true, this.requestTimeoutMs, request.handler, request.context)));
    }

    protected void pollOnce(long maxTimeoutMs) {
        try {
            this.drainGeneratedRequests();
            long now = this.time.milliseconds();
            long timeout = this.sendRequests(now, maxTimeoutMs);
            this.networkClient.poll(timeout, now);
            now = this.time.milliseconds();
            this.checkDisconnects(now);
            this.failExpiredRequests(now);
            this.unsentRequests.clean();
        }
        catch (FatalExitError fee) {
            throw fee;
        }
        catch (Throwable t) {
            if (t instanceof DisconnectException && !this.networkClient.active()) {
                return;
            }
            if (t instanceof InterruptedException && !this.isRunning()) {
                throw t;
            }
            this.log.error("unhandled exception caught in InterBrokerSendThread", t);
            throw new FatalExitError();
        }
    }

    @Override
    public void doWork() {
        this.pollOnce(Long.MAX_VALUE);
    }

    protected long sendRequests(long now, long maxTimeoutMs) {
        long pollTimeout = maxTimeoutMs;
        for (Node node : this.unsentRequests.nodes()) {
            Iterator<ClientRequest> requestIterator = this.unsentRequests.requestIterator(node);
            while (requestIterator.hasNext()) {
                ClientRequest request = requestIterator.next();
                if (this.networkClient.ready(node, now)) {
                    this.networkClient.send(request, now);
                    requestIterator.remove();
                    continue;
                }
                pollTimeout = Math.min(pollTimeout, this.networkClient.connectionDelay(node, now));
            }
        }
        return pollTimeout;
    }

    private void checkDisconnects(long now) {
        Iterator<Map.Entry<Node, ArrayDeque<ClientRequest>>> iterator = this.unsentRequests.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Node, ArrayDeque<ClientRequest>> entry = iterator.next();
            Node node = entry.getKey();
            ArrayDeque<ClientRequest> requests = entry.getValue();
            if (requests.isEmpty() || !this.networkClient.connectionFailed(node)) continue;
            iterator.remove();
            for (ClientRequest request : requests) {
                AuthenticationException authenticationException = this.networkClient.authenticationException(node);
                if (authenticationException != null) {
                    this.log.error("Failed to send the following request due to authentication error: {}", (Object)request);
                }
                InterBrokerSendThread.completeWithDisconnect(request, now, authenticationException);
            }
        }
    }

    private void failExpiredRequests(long now) {
        Collection<ClientRequest> timedOutRequests = this.unsentRequests.removeAllTimedOut(now);
        for (ClientRequest request : timedOutRequests) {
            this.log.debug("Failed to send the following request after {} ms: {}", (Object)request.requestTimeoutMs(), (Object)request);
            InterBrokerSendThread.completeWithDisconnect(request, now, null);
        }
    }

    private static void completeWithDisconnect(ClientRequest request, long now, AuthenticationException authenticationException) {
        RequestCompletionHandler handler = request.callback();
        handler.onComplete(new ClientResponse(request.makeHeader(request.requestBuilder().latestAllowedVersion()), handler, request.destination(), now, now, true, null, authenticationException, null));
    }

    protected boolean hasInFlightRequests(Node node) {
        return this.unsentRequests.hasUnsentRequests(node) || this.networkClient.hasInFlightRequests(node.idString());
    }

    public void wakeup() {
        this.networkClient.wakeup();
    }

    protected static final class UnsentRequests {
        private final Map<Node, ArrayDeque<ClientRequest>> unsent = new HashMap<Node, ArrayDeque<ClientRequest>>();

        protected UnsentRequests() {
        }

        public void put(Node node, ClientRequest request) {
            ArrayDeque requests = this.unsent.computeIfAbsent(node, n -> new ArrayDeque());
            requests.add(request);
        }

        Collection<ClientRequest> removeAllTimedOut(long now) {
            ArrayList<ClientRequest> expiredRequests = new ArrayList<ClientRequest>();
            for (ArrayDeque<ClientRequest> requests : this.unsent.values()) {
                Iterator<ClientRequest> requestIterator = requests.iterator();
                boolean foundExpiredRequest = false;
                while (requestIterator.hasNext() && !foundExpiredRequest) {
                    ClientRequest request = requestIterator.next();
                    long elapsedMs = Math.max(0L, now - request.createdTimeMs());
                    if (elapsedMs <= (long)request.requestTimeoutMs()) continue;
                    expiredRequests.add(request);
                    requestIterator.remove();
                    foundExpiredRequest = true;
                }
            }
            return expiredRequests;
        }

        void clean() {
            this.unsent.values().removeIf(ArrayDeque::isEmpty);
        }

        Iterator<Map.Entry<Node, ArrayDeque<ClientRequest>>> iterator() {
            return this.unsent.entrySet().iterator();
        }

        Iterator<ClientRequest> requestIterator(Node node) {
            ArrayDeque<ClientRequest> requests = this.unsent.get(node);
            return requests == null ? Collections.emptyIterator() : requests.iterator();
        }

        boolean hasUnsentRequests(Node node) {
            return this.requestIterator(node).hasNext();
        }

        public void clearUnsentRequests(Node node) {
            ArrayDeque<ClientRequest> requests = this.unsent.get(node);
            if (requests != null) {
                requests.clear();
            }
        }

        Set<Node> nodes() {
            return this.unsent.keySet();
        }
    }
}

